//Some analytics to help me know how people are reading...
var _gaq = _gaq || [];
_gaq.push(['_setAccount', 'UA-38641917-1']);
_gaq.push(['_trackPageview']);

(function () {
	var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
	ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
	var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
})();

Array.prototype.shuffle = function () {
	var s = [];
	while (this.length) s.push(this.splice(Math.random() * this.length, 1)[0]);
	while (s.length) this.push(s.pop());
	return this;
};

function changeText() {
	document.getElementById("p1").innerHTML = "Audio On";//so I know a change has occurred. 
	character.sandbox.soundon = 1;
	return character;
};



/*
 function on_load() {

	var button = document.getElementById("toggleButton");

	if(button.addEventListener){
		 button.addEventListener("click", ChangeText);
	} else {
		 button.attachEvent("click", ChangeText);
	};
 };

 window.onload = on_load();

*/


/* A unique id for your game. This is never displayed. I use a UUID,
 * but you can use anything that is guaranteed unique (a URL you own,
 * or a variation on your email address, for example). */
undum.game.id = "markmarinocomstorybook7a";

/* A string indicating what version of the game this is. Versions are
 * used to control saved-games. If you change the content of a game,
 * the saved games are unlikely to work. Changing this version number
 * prevents Undum from trying to load the saved-game and crashing. */
undum.game.version = "1.31";


/* The situations that the game can be in. Each has a unique ID. */
undum.game.situations = {};


undum.game.situations['start'] = new undum.SimpleSituation(
	"<p>Don't worry. I've finally got everything under control. I'm going to behave the way you'd expect. You see, over the past several stories, I have been experiencing what we might call <em>textual difficulties</em>.  Coughing up little bits of pageballs of stories here, telling scenes out of place there. You know, typical kinds of magical book stuff.  And I wanted to let you know that this time I've finally got it ALL FIGURED OUT.  You see, there was something going on with my index, and -- well, I won't go into all the gory details, but suffice it to say, all that nonsense has finally, once and for all, stopped.</p>\
	<p>So, rather than my usual rambles, let's just get on with the story, which, by the way, was primarily dreamed up by one of the two children who dream up these stories.  The girl child in fact.</p>\
	<p>So before the words get cold, <a href='landstartprevious'>let us  begin!</a></p>"
);

undum.game.situations['landstartprevious'] = new undum.SimpleSituation(
	"<p>Oh, I did forget one thing. This tale began, of course, in the Tangerine House.</p>\
	<p class='transient'>But there were previous tales you can read. Do you want to take a look at one of those first?</p>\
	<ul class='options'><li><a href='http://markcmarino.com/tales/storybook3.html'>Mysterious Floor</a></li>\
	<li><a href='http://markcmarino.com/tales/storybook2wobbles.html'>Parrot the Pirate</a></li>\
    <li><a href='http://markcmarino.com/tales/storybook4wobbles.html'>Switcheroo</a></li>\
    <li><a href='http://markcmarino.com/tales/storybook6switch.html'>Spy Eye</a></li>\
	<li><a href='landstarta'>Or Keep Reading this story.</a></li>\
	</ul></p>",
	{
		enter: function (character, system, from) {
//			character.qualities.couragearray.push(3);
//			character.qualities.couragearray.push(3);
//           system.setQuality("courage", character.qualities.couragearray);
 //           system.CourageAdjectivesQuality(character.qualities.couragearray);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
//			system.setQuality("distance", "2/5");
		}
	}
);


undum.game.situations['landstarta'] = new undum.SimpleSituation(
	"<h1>The Land Down Under</h1>\
		<center><img src='media/games/tutorial/images/Landdown_header.png'></center>\
	<p>Lin had just finished giving the new foster kids, two siblings, Wanda and Peter, the usual tour of the Tangerine House, when the girl with the big wild hair stopped to stare at the floor.  There, where the wood of the landing should have been, was a rectangle of glass that offered a window into another world, like a holiday department store display filled with figures moving about a city.  Or think of it like a fish tank.  Except inside, there were not fish, but little paper people with squarish heads moving around a beautiful paper city in a dance-like pattern.  The effect was mesmerizing, and Lin herself had often stopped to stare at it.</p>\
	<p>'Wow,' said Wanda, leaning <a href='landstart1'>down to look.</a></p>\
	<center><img src='media/games/tutorial/images/landdown1_440.png' alt='the kids gaze at the Land Down Under'></center>",
	{
		enter: function (character, system, from) {
			//   system.writeSound(character, '../pirateaudio/piratestart');
			character.sandbox.name = system.getName();
			/*         	if (character.sandbox.spypovnum==0){
						  system.write("<p>Hi, Ichel.</p>");
						  }
						  else {
						  system.write("<p>Juan, Juan, Juan.</p>");
						  } */
		}
	}
);



undum.game.situations['landstart1'] = new undum.SimpleSituation(
	"<p>Wanda couldn't believe that any place could be this perfect (<em>which is actually a good thing not to believe</em>).  Everything was in order, in its place. Everything was neat and tidy.  Not one blemish.  Not one mark. Not one stain.   And the people moved in such beautiful paths, never bumping into anyone or getting into anyone else's way.  It was like watching a perfect ice skating routine or the interlocking gears of an intricate clock.</p>\
	<p>'Pete, this is paradise!' she squealed.</p>\
	<p>'Perfection,' he replied, excitedly, a little drool dripping from his gaping mouth, which he quickly disguised <a href='landstart2'>with a bored yawn.</a></p>",
	{
		enter: function (character, system, from) {
		//	system.write("<p>This is a test line.</p>");
		}
	}
);



// Experimenting with breaking up this dialogue
undum.game.situations['landstart2'] = new undum.SimpleSituation(
	"<p>'You have to take us there!' shouted Wanda, yanking Lin's arm. </p>\
	<p>Although his face had returned to its usual blank stare, at this suggestion, Peter's eyes gave a little start.</p>\
	<p>But Lin was her usual calm self.  Unemotional, especially in the face of this Wanda character who reminded her a little too much of her former foster sister, a noisy, bossy girl who used her 'big personality' as a cover for her meanness and cruelty.</p>\
	<p>'Where is this?'</p>\
	<p>Lin weighed her possible responses.</p>\
	<ul class='options'>\
	<li><a href='landstartcant'>'No, you can't go there.'</a></li>\
    <li><a href='landstartbasement'>'It's the basement.'</a></li>\
    <li><a href='landstartdontask'>'Don't ask.'</a></li>\
	</ul>"
);


// Can't go down there

undum.game.situations['landstartcant'] = new undum.SimpleSituation(
	"<p>'You can't go there.'</p>\
		<p>'Why not?' Wanda said, 'I must go there. I must, I must.' she demanded doing her best impression of Violet Beauregard from Willy Wonka.</p>\
		<p>'Well, I'm sorry,' replied Lin, but you can't.'</p>\
		<p>'That's no kind of answer,' said Wanda, not used to being told no. 'What's there?'</p>\
	    <ul class='options'>\
	    <li><a href='landstartbasement'>'It's the basement.'</a></li>\
  	    <li><a href='landstartdontask'>'Don't ask.'</a></li>\
		</ul>",
		{
			enter: function (character, system, from) {
				character.qualities.couragearray.push(1);
				var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
				system.setQuality("courage", mostCourage);
				system.write("<p class='transient'><em>That was a <str>bold</str> choice.</em></p>");
			}
		}
);

// land start basement


undum.game.situations['landstartbasement'] = new undum.SimpleSituation(
	"<p>'The basement,' replied Lin, and before Wanda could ask again, Lin added, 'It's off limits. I've never been down there -- because I value my life.'</p>\
      		<p>Wanda let out a loud and sharp 'Ha!' which seemed to surprise even Peter. But Lin did <a href='landstart3'>not offer more.</a></p>",
			  {
				  enter: function (character, system, from) {
					  character.qualities.couragearray.push(3);
					  var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
					  system.setQuality("courage", mostCourage);
					  system.write("<p class='transient'><em>That was a <str>timid</str> choice.</em></p>");
				  }
			  }
	  );


// dont ask
undum.game.situations['landstartdontask'] = new undum.SimpleSituation(
	"<p>'Don't ask,' replied Lin, although she knew what was coming next.</p>\
		<p>'Why not? WHY not? Why not?' <a href='landstartbecause'>Wanda whined.</a></p>",
		{
			enter: function (character, system, from) {
				character.qualities.couragearray.push(2);
				var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
				system.setQuality("courage", mostCourage);
				system.write("<p><em>That was a <str>safe</str> choice.</em></p>");
			}
		}
);

//because join up again.

undum.game.situations['landstartbecause'] = new undum.SimpleSituation(
	"<p>'Because it's down in the basement, and the basement is forbidden.'</p>\
			<p>'Likely story.  You just don't want me to go there.'</p>\
			<p><a href='landstart3'>Lin shrugged.</a></p>"
);



// Add more choice to this dialogue
undum.game.situations['landstart3'] = new undum.SimpleSituation(
	"<p>'Well, Linsy,' Ooo, that was grating, 'Could you at least let us take a peek?' asked Wanda, changing her tone to one that almost could've sounded sweet if she had any sweetness in her.</p>\
		<p>'<a href='landstart4'>No.'</a></p>"
);

undum.game.situations['landstart4'] = new undum.SimpleSituation(
	"<p>'A little insy weensy peek?'</p>\
		<p>'Sorry.'</p>\
		<p>'A tiny --'</p>\
		<p><a href='landstart5'>'Nope.'</a></p>"
);



// It all joins back together here
undum.game.situations['landstart5'] = new undum.SimpleSituation(
	"<p>'You're enjoying this,' said Wanda.</p>\
	<p>'Not at all,' but Lin had started to smile, and when Lin smiled, it was like when you let go of a squirrel. Good luck <a href='landstart6'>getting it back!</a></p>"
);

undum.game.situations['landstart6'] = new undum.SimpleSituation(
	"<p>But Wanda was in a mean mood from not getting her way, and so with a smile of her own, turned toward Lin and then tilted her head to one side.  The sight of it was very much like someone who is trying to view something <a href='landstart6a'>that is tilted.</a></p>"
);

// Clear up the path here

undum.game.situations['landstart6a'] = new undum.SimpleSituation(
	"<ul class='options'>\
			<li><a href='landstart7'>'Is something wrong?'</a></li>\
			<li><a href='landstartsmile'>'Oh, it's my smile, is it?'</a></li>\
		</ul>"
);


// Safe
undum.game.situations['landstart7'] = new undum.SimpleSituation(
	"<p>'Is something wrong?' Lin asked.</p>\
	<p>'Oh, no,' said Wanda, giggling and elbowing Peter, who was almost awakened from his usual stupor.</p>\
	<p>'Then why are you tilting your head like that?'</p>\
	<p>'Um, no reason,' the girl said, though her brother narrowed his eyes, which for Peter was the equivalent to shouting at his sister to stop.</p>\
	<p>'Oh, I see,' said Lin, her smile disappearing.  This was  <a href='landstartsmile'>only too familiar.</a></p>",
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(2);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
			system.write("<p class='transient'><em>That was a <str>safe</str> choice.</em></p>");
		}
	}
);


// Consider giving this a lasting impact on the story...

undum.game.situations['landstartsmile'] = new undum.SimpleSituation(
	"<p>'It's my smile, is it?' asked Lin. Then, </p>\
		<ul class='options'>\
			<li><a href='landstartsmilecrooked'>'I do it on purpose.'</a></li>\
			<li><a href='landsmilebells'>'I was born this way.'</a></li>\
			</ul>",
			{
				enter: function (character, system, from) {
					character.qualities.couragearray.push(1);
					var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
					system.setQuality("courage", mostCourage);
					system.write("<p class='transient'><em>That was a <str>bold</str> choice.</em></p>");
				}
			}
	);



//A choice of possible Lin responses
// Safe
undum.game.situations['landstartsmilecrooked'] = new undum.SimpleSituation(
	"<p>'I do it on purpose. Let me explain.  I'm trying to smile like this to make you feel like the house is tilting.'</p>\
	<p>'Really?' asked the boy <a href='landstartsmile2'>surprised again.</a></p>"
);

undum.game.situations['landstartsmile2'] = new undum.SimpleSituation(
	"<ul class='options'>\
			<li><a href='landsmiledeflect'>'Yep.'</a></li>\
			<li><a href='landsmilebells'>'I was born this way.'</a></li>\
			</ul>"
);


undum.game.situations['landsmiledeflect'] = new undum.SimpleSituation(
	"<p>'Yep.' Lin was starting to detest Wanda. 'Just a little <a href='landstart8'>'optical illusion.'</a></p>",
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(2);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
			}
		}
);



undum.game.situations['landsmilebells'] = new undum.SimpleSituation(
	"<p>'I was born that way,' said Lin. 'I have something called Bells Palsy.  I've had it since I was born. Makes my smile a little crooked. But Mrs. Wobbles says it makes it so that my smile is always a smile whether I'm right side up <a href='landstart8'>or upside down.'</a></p>",
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(1);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
			}
		}
);

undum.game.situations['landstart8'] = new undum.SimpleSituation(
	"<p>'Oh.' said Peter not knowing what to say. 'Cool.'</p>\
	<p>'Sure,' Lin replied, catching sight of herself in a mirror. 'Way cool.' And she stared for a moment into the mirror, tilting her head ever so slightly to the left so that even for just one minute, her smile <a href='landbreakfast'>could be straight.</a></p>"
);


undum.game.situations['landbreakfast'] = new undum.SimpleSituation(
	"<p>At breakfast the next day, Lin felt a little sluggish. Getting out of bed was hard on this grey morning, and the wind was rattling around outside.  At the table, there were two seats empty. </p>\
	<p>'Hey, Lin,' said Mrs. Wobbles, 'Where are the new kids?'</p>\
	<p>Lin answered without even looking up. 'Probably <a href='landbreakfast1'>sleeping in.'</a></p>"
);

// Keep repeating choice to go check on them.



undum.game.situations['landbreakfast1'] = new undum.SimpleSituation(
	"<p>'Lin,' chided Mrs. Wobbles, 'You know sometimes the new kids need a little more help. Remember what it was like for you?  Why don't you go check on 'em, give them the royal treatment, a personal invite to breakfast?'</p>\
   <ul class='options'>\
   		<li><a href='landbreakfastcomply'>Do it right away.</a></li>\
   		<li><a href='landbreakfastresist'>Try to ignore it.</a></li>\
   		</ul>"
);

//Don't do it. 
undum.game.situations['landbreakfastresist'] = new undum.SimpleSituation(
	"<p>It was a little unnerving to see a face appear in her rice and raisins. But there it was.  And that it looked a bit like Mrs. Wobbles was even more unnerving.  But nothing was as unsettling as when it spoke.</p>\
 	<p>'You are ignoring me?' asked the mouth.</p>\
	 <p>Lin recognized this as one of those questions that did not have a good answer -- or at least one that wouldn't anger the rice and raisin monster further. So she just froze.  But as the mouth grew wide enough to eat her, she realized the time to move was now.  She leapt up and ran to the stairs, hearing Mrs. Wobbles' laugh chasing her <a href='landbreakfast2'>all the way.</a></p>",
	 {
		enter: function (character, system, from) {
			character.qualities.couragearray.push(2);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
			system.write("<p class='transient'><em>That was a <str>safe</str> choice.</em></p>");
		}
	}
);


undum.game.situations['landbreakfastcomply'] = new undum.SimpleSituation(
	"<p>Lin knew better than to give a 'why me?' look, even though it meant that her rice and raisins would go cold and the rest would probably be gobbled up by the time she got back.</p>\
	<p>No, Lin always did what anyone asked the first time they asked.  She was, in short, <a href='landbreakfast2'>awesome that way.</a></p>" ,
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(2);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
			system.write("<p class='transient'><em>That was a <str>safe</str> choice.</em></p>");
		}
	}
);



undum.game.situations['landbreakfast2'] = new undum.SimpleSituation(
	"<p>As she climbed up the stairs, she started thinking back to her first time waking up in the strange, orange house.  So many unfamiliar kids.   So many smells and sounds.  It was all so noisy.  Of course, Lin was <a href='landbreakfast2a'>used to noisy homes.</a></p>\
      <p>Just like last night <a href='./firstnight' class='once'>for Peter and Wanda.</a></p>\
      <p>Lin was so lost in these memories that she didn't even notice that she had reached the top of the stairs and had already walked <a href='landbreakfast6'>into Wanda's room.</a></p>",
	{
		actions: {
			'firstnight': function (character, system, action) {
				system.write("<p><em>Wait? What did you click on? There's nothing here to report.  Guess you think this book is infinite.  If only that were the case. Just try one of the other choices.</em></p>");
			}
		}
	}
);





undum.game.situations['landbreakfast2a'] = new undum.SimpleSituation(
	"<p>In her last foster placement, she was one of 8 kids -- two foster, two adopted, 2 biological, and 2 street kids who just crashed at the house with them. So many different ages and worst of all: 5 of them were going through  <a href='./puberty' class='once'>PUBERTY!</a> Ahem. <a href='landbreakfast3'>Yep. Yikes.</a></p>",
	{
		enter: function (character, system, from) {
			system.write("<p class='transient'><em>Excellent.  In this tale, reading is a powerful activity. The more you read, the more page points. And the more page points you have, the more opportunities you get. Rather like real life, wouldn't you say?</em></p>");
			system.animateQuality("strength", character.qualities.strength + 5);
		},
		actions: {
			'puberty': function (character, system, action) {
				system.write("<em>Ah, puberty, that time in everyone's life where hair and smells sprout in places that were formerly smooth and unsmelly.</em>");
				system.animateQuality("strength", character.qualities.strength + 5);

			}
		}
	}
);

// Explain puberty


undum.game.situations['landbreakfast3'] = new undum.SimpleSituation(
	"<p>Want privacy in the bathroom? No way. Want a quiet place to read? Uh-uh. Want to just have time to hear yourself think -- hear yourself think, what was that?  Actually, Mrs. Wobbles' Tangerine House had been a step toward the more orderly, since no one wanted to break one of her rules, and keeping the ruckus down to a low roar was one <a href='landbreakfast4'>of the big ones.</a></p>"
);



undum.game.situations['landbreakfast4'] = new undum.SimpleSituation(
	"<p>And worst of all was the one biological sister.  Wonderful Juanita.  She was only four years older than Lin but she had already begun to develop and so had been wearing training bras, which she loved to shove in Lin's face at laundry time.  She was big and loud, 'boisterous' the foster dad called her, but to Lin she was just a bully.  Always taking her books and tossing them everywhere.  Always talking loudly about the fun she was having that Lin was <a href='landbreakfast5'> missing out on.</a></p>"
);




undum.game.situations['landbreakfast5'] = new undum.SimpleSituation(
	"<p>You see, Lin was too young to understand that people who have to talk about what a great time they're having are usually trying to wallpaper over their misery.  Juanita had towering walls of wallpapered misery. Meanwhile, she was determined to paper Lin up in those miserable <a href='landbreakfast6'>walls with her.</a></p>");


undum.game.situations['landbreakfast6'] = new undum.SimpleSituation(
	"<p>Lin hadn't noticed she had sat down on Wanda's bed.  Even more, she didn't realize that the clump of fluff she sat on was not Wanda's legs, arms, or even her head -- but a pile of her clothes that had yet to be put away.</p>\
	<p>'Come on, Wanda, let's get up. Breakfast,' she said, and then, catching up on all of this, 'Oh.' She felt a little, tiny bit stupid about not noticing.</p>\
	<p class='transient'>Where should <a href='landbreakhunt'>Lin look next?</a></p>"
);




undum.game.situations['landbreakhunt'] = new undum.SimpleSituation(
	"<ul class='options'>\
		<li><a href='landbreakpeter'>Peter's room</a></li>\
		<li><a href='landbreakalice'>The alligator bathroom</a></li>\
		<li><a href='landbreakstairs'>The stairs</a></li>\
		<li><a href='landbreakfourth'>The fourth floor</a></li>\
		</ul>");


//alice
undum.game.situations['landbreakalice'] = new undum.SimpleSituation(
	"<p>If someone were to disappear in the magical home, the first place you'd think to look might be a bathroom with an alligator in it. It would be my first choice.</p>\
	<p>But there was Alice.  Her normal cheerful self.  And by cheerful I mean, she wasn't actively trying to eat anyone.  Kind of like adults before they get their coffee.  Keep your fingers away from their mouths. And it looked like she hadn't eaten anyone lately either. Lin tossed her a marshmallow from the bowl and headed on.</p>\
	<p>Where else <a href='landbreakhunt'>might Lin look?</a></p>"
);




//Fourth Floor
undum.game.situations['landbreakfourth'] = new undum.SimpleSituation(
	"<p>Lin knows this house well.  And she knew that there was one floor better than any other if you did not want to be found, the fourth floor. Not because it had good hiding places but because its portal windows allowed you to go to any place.  And while children who went up there wouldn't be there long, the activated portal would still be open for at least 30 minutes after, and the departures board would indicate whence it had led.</p>\
	<p>However, when Lin arrived, she only found Zach, Philip, and Henry staring like zombies at a video game machine that had entranced them.</p> \
     <p>Where else <a href='landbreakhunt'>might Lin look?</a></p>"
);




// Peter         
undum.game.situations['landbreakpeter'] = new undum.SimpleSituation(
	"<p>Maybe Wanda had gone to her brother's room. Siblings often clung together when they first arrived at the Tangerine House.</p>\
     <p>Peter was now sharing a room with Stevie and Leroy who were long down at breakfast, probably working on their sixth stack of pancakes, having finished ALL of the rice and raisins. Sigh.  But when she got to the boys' room, she found it just as empty as Wanda's.  One strange thing was that Peter's shlocks were gone -- these were combo shoes and socks that Peter had worn upstairs to bed that first night.</p>\
	<p>Well, thought Lin, wherever he is, at least he's got some shlocks.</p>\
	     <p>Where else <a href='landbreakhunt'>might Lin look?</a></p>"
);


// stairs

undum.game.situations['landbreakstairs'] = new undum.SimpleSituation(
	"<p>As she headed for the stairs, she noticed something strange.</p>\
	<p>From what she could tell, there were water splotches all the way down the stairs.  That was strange. On closer inspection -- and believe me, you wouldn't want to be doing the inspecting -- these splotches were in fact, sticky, icky, gushy, drool.</p>\
	<p>She followed the drool splotches down the stairs onto the landing, down another flight to the second floor, onto another landing, and down to the first floor. From there they splotched their way more intermittently, as though the drooler were occasionally remembering to swallow. And around they went to the --</p>\
	<p>'Oh, no, not the basement,' thought Lin.</p>\
	<p>Yup. Down into the basement <a href='landbreakfast9'>they went.</a></p>"
);



undum.game.situations['landbreakfast9'] = new undum.SimpleSituation(
	"<p>Now, at this point you need to make a rather important choice.  Should Lin follow these drool splotches into the forbidden basement and risk the wrath of Mrs. Wobbles? Or should she just go back to her rice and raisins -- assuming there were any left -- and pretend that everything was okay.</p>\
    <ul class='options'>\
    	<li><a href='landriceandraisins'>Rice and Raisins</a></li>\
    	<li><a href='landrisk'>Take a risk for once!</a></li>\
    </ul>"
);


// Work on previous

// Rice and Raisins 
undum.game.situations['landriceandraisins'] = new undum.SimpleSituation(
	"<p>Lin walked back to her seat, sat down, and stared at the cold remnants of her rice and raisins.  She caught herself almost drooling at the thought of food, and the drool made her feel quite guilty.  She left the table and went to sleep for the remainder of this story.</p>\
      <p>Well, there you go. That's what focusing only on your breakfast gets you.<p>",
	{
		enter: function (character, system, from) {
			if (character.qualities.jetpack >= 1) {
				character.sandbox.whereto = from;
				system.write("<br/><em><p class='transient'>But you don't really want to end this story just like that.  You could use a jetpack and make a different choice.</em></p>");
				system.write("<p class='transient'><ul class='options'>\
			<li><a href='./jetpackgo' class='once' onClick='_gaq.push([\"_trackEvent\",  \"Spyeye\", \"Jetpack\", \"used\"]);'>Use Jetpack?</a></li>\
			<li><a href='landriceandraisins2'>Don't</a></li></ul></p>");
			}
			else {
				system.write("<p>If only you had a jetpack. Then, you could try a different, <a href='landriceandraisins2'>more exciting path.</a></p>");
			}
		},
		actions: {
			'jetpackgo': function (character, system, action) {
				system.setQuality("jetpack", character.qualities.jetpack - 2);
				system.write("<p class='transient'>When the big dial is turned to 'Launch,' the jetpacks rumble to life, spewing white steam of smoke and rattling like a snoring pig. Lin managed to put it on like a backpack BEFORE pressing 'GO.'</p>\
				 <p class='transient'>3-2-1</p>\
				 <p class='transient'>The jetpacks rocketed Lin up through the roof.  Eventually, she was above the smog and in a clear blue sky.</p>\
				 <p class='transient'>A message on the strap flashes: Approaching Jump</p>\
				 <p class='transient'>What could this mean? Jump where? Well, only <a href='landbreakfast9'>one way to find out!</a></p>");
			}
		}
	}
);




undum.game.situations['landriceandraisins2'] = new undum.SimpleSituation(
	"<p>A life of rice and raisins is certainly safe from anything exciting happening. <a href='start'>How about trying the story again?</a>",
	{
		exit: function (character, system, to) {
			$("#content").empty();
		}
	}
);
// ENDING


// in the floor     
undum.game.situations['landlookfloor'] = new undum.SimpleSituation(
	"<p>Lin stopped to look at the panel in the floor, as she often did even if she was on her way somewhere.  Lin just loved the perfect harmony of this little world beneath the glass, everything humming and circling so wonderfully in place.  And the people in the world, too, were entrancing, though they all looked identical.  Well, at least all the men looked like all the men (with boys looking like smaller men) and the same with all the women and girls.</p>\
      <p>But on closer inspection, this morning, something was not right, something was different.  And Lin had looked at this world beneath the glass for long enough, sometimes whole entire afternoons, to know if something had changed, because it never did.  But on this morning, there before her <a href='landlookfloor1'>were two extra figures.</a></p>"
);

undum.game.situations['landlookfloor1'] = new undum.SimpleSituation(
	"<p>'Oh, no,' thought Lin.</p>\
	<p>And it was not clear what moved her feet faster, the thought of the siblings caught in the world beneath the glass or the possibility that they might ruin it or the possibility that they had taken the only two open spaces in a world Lin longed to live in more <a href='landrisk1'>than any other.</a></p>"
);



// Risk        
undum.game.situations['landrisk'] = new undum.SimpleSituation(
	"<p class='transient'><em>Ah, I knew you'd take this option. Especially because you couldn't really be reading these words if you hadn't. So how could I be wrong? I'm a regular Schroedinger's Cat book! Nah-nah-nah-nah-nah-nah-nah. Shake butt. Shake butt. Can a book shake its butt? I learned that from the skeleton in that other story.  Where was I -- Oh, yeah--</em></p>\
      <p class='transient'>Hmm. Sorry. That behavior was a little unseemly.  At least  <a href='landriska'>for a narrating book.</a></p>",
	  {
		enter: function (character, system, from) {
			character.qualities.couragearray.push(1);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
			system.write("<p class='transient'><em>That was a <str>bold</str> choice.</em></p>");
		}
	}
);

undum.game.situations['landriska'] = new undum.SimpleSituation(
	"<p>Creeeeeeeeeeeeeak went the door leading to the basement and immediately Wonton appeared in an explosion of yapping as though he were face-to-face with <a href='./santana' class='once'>Santana the devil wind</a> himself. Lin jumped back freaking out at the possibility of Mrs. Wobbles hearing her, but the magical mom was apparently not in creaking distance.  Down the stairs she went and into this space that none of the children had ever seen and lived to talk about -- basically because they'd <a href='landrisk1'>never seen it.</a></p>",
	{
		actions: {
			'santana': function (character, system, action) {
				system.write("<p>Santana was the nemesis of the Tangerine House -- and by nemesis I mean its polar opposite, its greatest foe, for while the Tangerine House brought people together into its warmth, the devil wind blew everything apart.  You can read more about it in the other stories.</p>");
				system.animateQuality("strength", character.qualities.strength + 5);
			}

		}
	}

);


undum.game.situations['landrisk1'] = new undum.SimpleSituation(
	"<p>At the bottom of the stairs, Lin found the floor cold.  She walked gingerly because one never knew if the floor was suddenly going to change to lava or lemonade or lollipops or laser beams.  You couldn't be too cautious in Mrs. Wobbles' house. Fortunately, this was just good-old, ice-cold ordinary concrete.</p>\
     <p>And, what was more, the rest of the basement was equally ordinary. Not unlike any other.  At first glance, at least. She was tempted <a href='./explorebasement' class='once'>to take a look around</a>. But Lin then noticed kitty-corner to the washing machine, there shone a sparkling <a href='landrisk2'>see-through door.</a></p>",
	{
		actions: {
			'explorebasement': function (character, system, action) {
				system.write("<p>You see, basements -- not the modern man cave or woman lair kind -- traditional basements are not so perfect.  Perfectly imperfect. 'Unfinished' is the polite way to say it. Take this one, with its spiderwebs and ant traps and wind repellant -- oh, and some dark, creepy corners, but nothing you wouldn't expect. A fridge, a furnace, a trunk of scrolls, a framed map of Zoomland, walls lined with bookshelves loaded with magical, curious, tempting books.  But there was that door. Truly Extraordinary!</p>");
				system.animateQuality("strength", character.qualities.strength + 5);
			}
		}
	}
);


undum.game.situations['landrisk2'] = new undum.SimpleSituation(
	"<p>Through that door, Lin could see the marvelous paper land she'd so often watched beneath the glass of the first floor landing -- except unlike the view from above, which flattened the land out, from the side, the people were tall, the buildings taller, and  everything seemed almost three-dimensional.</p> \
      <p>What, she wondered, would happen if she were to enter? Something in the dark, cold shadows of the basement seemed to suggest this would end terribly -- but something else, a tingling inside her yearned to be <a href='landrisk2pre'>part of that perfection.</a></p>"
);

//CHOICE      
undum.game.situations['landrisk2pre'] = new undum.SimpleSituation(
	"<p>But how would one go in? With a tug that revealed her strength notably greater than her size, she swung the door open.  Inside, through a curtain of translucent plastic strips, the gracefully gliding world proceeded.</p>\
      <p>No sooner did she wonder what would happen to her next, when a cellar <a href='landrisk2a'>mouse wandered in.</a></p>"
);


undum.game.situations['landrisk2a'] = new undum.SimpleSituation(
	"<p>At first, she was tempted to rescue it, just yank it back out by its tail, but soon she realized that wouldn't be possible.  For you see, the mouse had transformed instantly into a paper mouse -- although to be honest, it looked a little more <a href='landrisk2b'>spidery than mousy.</a>"
);

// Poem    

undum.game.situations['landrisk2b'] = new undum.SimpleSituation(
	"<p> So, that's how it worked.  If you went in, you'd be transformed into paper, presumably a paper being most resembling your previous form.  That meant Lin would be turned into a paper person who looked like everyone else.  No more the odd one out.  But how would people know where she had gone.  There was a little sticky note pad on the laundry folding table.  On a closer look, she saw that the top note had some writing, <a href='./landmousepoem' class='once'>some sort of poem.</a>  So, she removed that one to get to a plain one and scrawled a quick note that she had gone into the Land Down Under to find Wanda and Peter.  That was why she was going wasn't it? She did intend to come back, <a href='landrisk3'>didn't she?</a></p>",
	{
		actions: {
			'landmousepoem': function (character, system, action) {
				system.setCharacterText("<h1>Poetry Power-up</h1><p>'The Spotted Mouse, Part I' <br/>by Genevieve Marino<br/>Excellent find!</p>");
				system.write("<center><h3>Poetry Power-up</h3></center>\
       <center>The Spotted Mouse</center>\
      <center>Part I</center>\
       <center>by Genevieve Marino</center><br/>\
<p>The spotted mouse was a curious fellow<br/>\
White spots on his back and even below<br/>\
Not the same as his mom or his dad or his brother<br/>\
With certainty they said he was like no other</p><br/>\
<p>The spotted mouse was ashamed of his spots<br/>\
Looking at them left his stomach in knots<br/>\
And when he forgot, he could see others staring<br/>\
None were looking a what he was wearing</p><br/>\
<p>The spotted mouse tried to get rid of his spots<br/>\
Tried to wash them off himself with a cloth<br/>\
But to his dismay they would not wash off<br/>\
The spots stuck on him and he on his spots</p><br/>");
				system.animateQuality("skill", character.qualities.skill + 7);
				system.write("<p><em>You have found a poem! Excellent! Gather up poems wherever you find them! They <a href='landrisk3' class='transient'>cast powerful spells!</a></em></p><br/>");
				if (character.qualities.skill > 20) {
					system.write("<p>You have now earned enough Poetry Power-ups to purchase another 2 Jetpacks.  They will cost you 30 Poetry Power-ups. Would you like to trade for them?</p>\
   		<ul class='options'>\
   		<li><a href='landmouseyespacks' class='transient'>Yes, I wish to trade.</a></li>\
   		<li><a href='landmousenopacks' class='transient'>No, I do not.</a></li>\
   		</ul>");
				}
			}
		}
	}
);


undum.game.situations['landmousenopacks'] = new undum.SimpleSituation(
	"<p>Okay, no problem. <a href='landrisk3'>Perhaps next time.</a></p>"
);



undum.game.situations['landmouseyespacks'] = new undum.SimpleSituation(
	"<p>Excellent, you now have 2 more jetpacks for use for traveling back to a previous key choice.  Let's get <a href='landrisk3'>back to the story.</a></p>",
	{
		enter: function (character, system, from) {
			system.animateQuality("skill", character.qualities.skill - 30);
			system.animateQuality("jetpack", character.qualities.jetpack + 2);
		}
	}
);





undum.game.situations['landrisk3'] = new undum.SimpleSituation(
	"<p>This was the moment.</p>\
     <ul class='options'>\
     <li><a href='landdownenter'>Go in.</a></li>\
     <li><a href='landdownending'>Turn back!</a></li>\
     </ul>"
);




/*
Made it here]
{ CUT choice probably}
Choice�
		[which color to choose]
		[white]
		[pink]
		{if they read the story they'll know that it was purple}
 
 
Because she knew about the Crazy Willy story, she knew that once she saw a hint of purple she had to reach out, grab the air by the purple and yanked backward creating a giant popping sound like unsticking a plunger from a toilet or popping your bubble gum.
}


*/

//ENDING
undum.game.situations['landdownending'] = new undum.SimpleSituation(
	"<p>Sometimes, we're not up for an adventure.  I understand.</p>\
      <p>Lin went back up to her room and lived out an ordinary life.</p>\
      <p><a href='start'>Want to read it again?</a>",
	{
		exit: function (character, system, to) {
			$("#content").empty();
		}
	}
);

undum.game.situations['landdownenter'] = new undum.SimpleSituation(
	"<p>She knew that once she passed the doorway, she wouldn't be able to control herself and she would look identical to at least the other women, so she went to the washing machine, wrote a sticky note, and pasted it on her forehead and then walked through the door -- which, of course, turned<a href='landdownentera'> her into paper.</a></p>",
	{
		enter: function (character, system, from) {
			system.setQuality("distance", "1/5");
			system.animateQuality("complete", character.qualities.complete + 20);
			character.qualities.couragearray.push(1);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
		}
	}
);


// MILESTONE

undum.game.situations['landdownentera'] = new undum.SimpleSituation(
	"<h1>Enter the Land</h1>\
    <p>Before she knew it, Lin was gliding along a seemingly endless track through the most beautiful village she had ever seen -- well, or at least equally beautiful to the one she had gazed at endlessly through the glass panel. Everywhere she looked was a picture-perfect vista.  Paper hillsides stood before paper mountains, tall, white-peaked, and majestic. And beneath them cute clusters of adorable little cottages with paper tile roofs and wide, white-shuttered windows, twinkling in the light from the paper sun.  Each cottage was framed by two perfect trees and every fourth one had a paper dog or cat in the yard, each identical, <a href='landdownenter1'>perfectly groomed.</a></p>"
);


undum.game.situations['landdownenter1'] = new undum.SimpleSituation(
	"<p>When I say these were made out of paper, I don't mean three-dimensional buildings made of paper m&acirc;ch&eacute;, I mean that each person, place, and thing was one sheet of paper wide. Only the buildings had any dimension to them (other than flat) and they were merely made of sheets of paper arranged <a href='landdownenter2'>in boxy forms.</a></p>"
);


undum.game.situations['landdownenter2'] = new undum.SimpleSituation(
	"<p>Eventually Lin looked down to see how she was moving because she noticed, to her slight dismay, that she could not move her legs.  Could not even separate them. Instead she found the paper still connected with a line down the middle and slipped into a metal post that pulled her along the conveyor belt. She must have been placed in an empty spot because all of the people were perfectly <a href='landdownenter3'>spaced around her.</a></p>"
);


undum.game.situations['landdownenter3'] = new undum.SimpleSituation(
	"<p><ul class='options'>\
		<li><a href='landdownenter3pond'>Look the pond</a></li>\
		<li><a href='landdownenter3houses'>Look at the houses</a></li>\
		<li><a href='landdownenter3people'>Look at the other people</a></li>\
	</ul></p>"
);


// Look at the other people  

undum.game.situations['landdownenter3people'] = new undum.SimpleSituation(
	"<p>Because she could not turn her head and look around, Lin could only see the backs of the heads of the people in front of her, men and women, alike.  <em>Yes, just those two genders. There were no in-betweens.  More to the point, each one looked identical to its kind. Perfect conformity.</em></p>\
        <p>Actually, due to a bend in the track on which she glided, she could see that stretching on before her, there was a near endless line of people.  Based on her observations from the staircase in Mrs. Wobbles' house back when she was a full person, she believed that the track was one continuous loop of people. Lin could only assume that she herself must look exactly like the others as well.  And even though assuming is usually a bad idea, in this case, <a href='landtrackb'>she was right.</a></p>"
);


// Look at the pond 

undum.game.situations['landdownenter3pond'] = new undum.SimpleSituation(
	"<p>But just now, she passed a little pond and with great effort managed to bend her head down just a bit to glance at her reflection.  What she saw was truly remarkable.  There she was with that perfectly balanced head, looking just as cute as any of the women or girls in this land -- this land down under Mrs. Wobbles' house.  Her eyes were identically  shaped.  Her cheeks were equally rosy, and her smile, yes, her smile was finally even -- symmetrical we say, when something looks the same on both sides, like a circle or a square as opposed to different on each side, slightly or greatly different,  like a <a href='landdownenter4'>pothole or a blob.</a></p>"
);

undum.game.situations['landdownenter4'] = new undum.SimpleSituation(
	"<p>Yes, she looked beautiful, perfect, but, to tell all, she did not look a thing like Lin -- who, of course, was more beautiful than she <a href='landdownenter5'>would ever know.</a></p>"
);




undum.game.situations['landdownenter5'] = new undum.SimpleSituation(
	"<p> Oh, and she still had a post-it on her head, which was attracting some glances from the other people moving in the opposite direction on a parallel track.  Though they could only smile, something about the way they strained their paper bodies made Lin think they were <a href='landtrackb'>troubled by her.</a></p>"
);


// Looks at the houses
undum.game.situations['landdownenter3houses'] = new undum.SimpleSituation(
	"<p>The houses were truly remarkable.  That is to say, the sight of row upon row of identical houses was remarkable -- for no individual house was notable in itself. They reminded Lin of the cookie cutter houses of the new, gated developments she had seen out of the bus window on her way to Zoomland amusement park. In fact, the sight of so many similar buildings, passing by with such regularity, gave the impression that you were not moving on a great winding track but instead stuck on a much smaller loop, like a hamster in a wheel, or a record needle stuck in a groove on <a href='./record' class='once'>a skipping record.</a></p>\
  <p>Lin found herself growing strangely fatigued by the whole experience, shaken awake when she passed one of <a href='landtrackb'>the similarly similar parks.</a></p>",
	{
		actions: {
			// Cut this down or out!
			'record': function (character, system, action) {
				system.write("<p>What is a record? Oh, yes. Good question.</p>\
        <p>You see, in the 20th century, to listen to recorded music, people would use these black, vinyl discs called records. This may sound strange to you future-loving, hologram-watching, Mars colony children, but let me explain.  To listen to one of these records, you would place a long arm on the record as the disc revolved on a spinning turn table. The arm ended in a needle, which we could say 'read' the record.<p>\
        <p>Now, the record was imprinted with a spiral of grooves, and as the record spun, the needle moved along the spiral 'landdownbfcourage'to the center of the record.  If the record was damaged, as the needle hit the damaged part, the song or recording would skip because the needle could not move to the next part of the spiral.  Now that I describe it, it is a wonder people put up with such non-book-like forms of entertainment.  At least, you don't have to worry about me narrating the same scene over and over again -- ha, ha.</p>");
				system.animateQuality("strength", character.qualities.strength + 5);
			}
		}
	}
);


// Track B Inside the House
undum.game.situations['landtrackb'] = new undum.SimpleSituation(
	"<p>She was coming into another cluster of identical houses, finally seeing them up close, how every detail, from the golden doorknobs to the lion-head knockers, was so perfectly drawn -- for everything looked as though sketched by a very talented and imaginative artist. Even more, they were perfectly cut! The outlines were arrow-straight, never jagged as when you accidentally snip across the line or leave some of the white around the edges for fear of cutting it.  Lin, too, liked to draw, but somehow, despite her best efforts, her drawings always came out uneven, bent, her cut-outs always came out ragged or crooked.  Uneven. Just like...</p>\
   <p><em>Like her</em>, a voice said somewhere within, and she tried to shake it out of her head because right now she had other problems. She was about to sail straight <a href='landtrackb1'>through a door.</a></p>"
);


undum.game.situations['landtrackb1'] = new undum.SimpleSituation(
	"<p>Inside, she was pulled into a little loop, where she moved in a kind of figure eight through the bottom floor and then up into the second floor, around it, and then back down.  A counter in the corner kept track of how many times she went around.  I guess this is how people stay some place, she thought, but do they ever stop?</p>\
   <p>And almost in answer to her question, she found herself slid down deeper into the track beside the other members of a family circling a cutout of a <a href='landtrackb1a'>dinner table.</a></p>"
);

undum.game.situations['landtrackb1a'] = new undum.SimpleSituation(
	"<p>Looking around the table, she saw the smiling faces of what she assumed was to be her family.  At either end of this elliptical table sat the mother and father, beaming at each other with perfect parent smiles.  When did anyone see that in homes, she wondered, remembering her squabbling foster-parents and all the bickering children, who behaved always as though they were in the middle of a kind of survival contest, stealing each other's food and even swiping at each other's smiles -- as though any other person's happiness stole some from <a href='landtackb1b'>their dwindling stash.</a></p>"
);


undum.game.situations['landtackb1b'] = new undum.SimpleSituation(
	"<p>But here was the perfect family -- and I do hope you haven't tired of me using that word yet -- a perfect daughter, two perfect sons, and, well, Lin, to balance the genders breakdown of the family. She was perfect, too, although she didn't feel it. On the table were drawings of a feast that made Thanksgiving look like leftovers.  Steaming, perfectly roasted turkeys, gleaming cranberries, mounds of mashed potatoes, but also dessert: big pies and fluffy cakes, and every manner of drink imaginable.  There was only one problem, they could not move their arms, and even if they could, they'd soon discover the drawings, like everything else, were only two-dimensional. Hardly something to put meat <a href='landtrackb1c'>on your...paper.</a></p>"
);


undum.game.situations['landtrackb1c'] = new undum.SimpleSituation(
	"<p>Suddenly, the girl turned to her and winked, sort of.  Since her face could not change, her one eye merely twinkled a bit.  Lin <a href='landtrackb2'>looked stunned.</a></p>"
);

// Track B2 Leaving the dinner table 

undum.game.situations['landtrackb2'] = new undum.SimpleSituation(
	"<p>After 'sitting' around the table for what seemed like a few minutes, the family was again dispersed around the house, only this time Lin and the other daughter were moving together.</p>\
		<ul class='options'>\
		    <li><a href='landtrackb2smile'>Just smile</a></li>\
			<li><a href='landtrackb2wink'>Give a wink and see if she responds</a></li>\
			<li><a href='landtrackb2hey'>Go bold and say, 'Hey, sis, what's up?'</a></li>\
		</ul>"
);


// Just smile

undum.game.situations['landtrackb2smile'] = new undum.SimpleSituation(
	"<p>Lin just gave a little smile, which since her face was already smiling, must not have looked like anything <a href='landtrackb2a'>different at all.</a></p>",
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(3);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
		}
	}
);


// Wink

undum.game.situations['landtrackb2wink'] = new undum.SimpleSituation(
	"<p>Because her face could not move, Lin did not know if her wink did much of anything, but she did feel a little movement around her left eye. In response, the sister seemed to cock her head to a side and regarded Lin for a bit, seeming <a href='landtrackb2a'>to size her up.</a></p>",
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(2);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
		}
	}
);
// Say, Hey, sis, what's up?


undum.game.situations['landtrackb2hey'] = new undum.SimpleSituation(
	"<p>'Hey, sis, what's up?' asked Lin.</p>\
	<p>This greeting sent a jolt through her sister, who almost popped back off <a href='landtrackb2a'>her foot pole.</a></p>",
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(1);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
		}
	}
);




undum.game.situations['landtrackb2a'] = new undum.SimpleSituation(
	"<p>'You're not from here,' said the girl from behind her.</p>\
	<p>Lin was frozen, literally, so she tried to pretend she hadn't heard the girl.</p>\
	<p>'I can tell you're not.'</p>\
	<p>'Uh, how?'</p>\
	<p>'You've got that Post-It note on your forehead.'</p>\
	<p>'I don't know what you mean,' said Lin.</p>\
	<p>'Oh my goodness, you're Lin.'</p>\
	<p>Lin's panic was replaced by a <a href='landtrackb2b'>wave of relief.</a></p>"
);


undum.game.situations['landtrackb2b'] = new undum.SimpleSituation(
	"<p>'Wanda?'</p>\
		<p>'Duh,' said Wanda, with enough snark to make her perfect smile seem to sneer. 'Who else? How did ya find me?'</p>\
		<p>'I just followed the drool.'</p>\
		<p>'Oh, right, Peter' said Wanda.  'Well, good thing this family had an opening for a daughter or two. Why didn't you tell <a href='landtackb2c'>me about the open spots?'</a></p>"
);

undum.game.situations['landtackb2c'] = new undum.SimpleSituation(
	"<p>'There weren't any.  Every spot was filled. We must've bumped off this family's daughters when we landed on the track. I suppose they can't tell the difference.'</p>\
		 <p>Wanda gasped. 'I wonder what happened  to their real daughters. And could everyone here be people who just wandered into <a href='landtrackb2d'>Mrs. Wobbles' basement?'</a></p>"
);

// Might need to resolve this later... The daughter could turn out to be the Queen of Hearts -- 


undum.game.situations['landtrackb2d'] = new undum.SimpleSituation(
	"<p>'I don't know.  I didn't even know these families existed. I could never see into the houses.'</p>\
	<p>'Well it takes some adjusting.  Remember our first night at Mrs. Wobbles' house.'</p>\
	<p>On that first night, -- <em>Wait, I don't know what night she's referring to.  I'm sure it's nothing, but I don't have any pages about that. Maybe she's just referencing the feelings anyone might have on their first night. Let's go with that. </em></p>\
	 <p>Lin took a long look around, taking it in. <a href='landtrackb2e'>'This is amazing!'</a>'</p>"
);


undum.game.situations['landtrackb2e'] = new undum.SimpleSituation(
	"<p>'Are you kidding me?' said Wanda.</p>\
				<p>'What're you, crazy?  Everything's so perfect.'</p>\
				<p>'That's what I thought, too, when I first arrived, but then, after a few cycles, you start to realize that this sucks.'</p>\
				<p>'What?' Lin honestly couldn't imagine what could be so awful?'</p>\
				<p>'It's just...all the same.'</p>\
				<p>'So?'</p>\
				<p>'Everything. The exact same. It's so incredibly boring.'</p>\
				<p>'Boring?'</p>\
				<p>'You'll see.'</p>\
				<p>'But where's Peter?' </p>\
				<p><a href='landtrackb2f'>'Peter, oh --'</a></p>"
);


undum.game.situations['landtrackb2f'] = new undum.SimpleSituation(
	"<p>But their conversation was cut short suddenly with the appearance of the mother who somehow managed through motionless eyes to give Lin a suspicious glance. She circled round them several times and then seemed to push them toward opposite bedrooms.  Wanda changed her tune almost immediately and greeted the mother -- or the taller version of themselves, for she really was identical to them, just larger, with a fake-sweet 'Night, Mother,' which Lin thought <a href='landtrackb3'>best to copy.</a></p>"
);


// Track B3: House Bedroom, night time

undum.game.situations['landtrackb3'] = new undum.SimpleSituation(
	"<p>And then before she knew it, she was flipped onto a bed, where she lay, while her metal post revolved around it, and a large paper number on the wall flipped with every rotation. As she lay motionless on the bed, she felt a cool, soothing breeze flow over her.  She guessed this was how they slept, only, of course, her eyes could not shut.</p>\
	<ul class='options'>\
		<li><a href='landtrackb4'>Go to sleep, don't risk it.</a></li>\
		<li><a href=landtrackb3a>Try to escape the house.</a></li>\
	</ul>"
);

//ESCAPE -- BOLD
undum.game.situations['landtrackb3a'] = new undum.SimpleSituation(
	"<p>Well, I didn't see that coming. I thought you'd stay more or less on track.  Okay. What exactly is your plan?</p>\
	<ul class='options'>\
		<li><a href='landtrackb3abend'>Bend yourself and catch the breeze</a></li>\
		<li><a href='landtrackb3a1'>Inflate yourself into 3 dimensions.</a></li>\
	</ul>",
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(1);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
			}
		}
);


// floating
undum.game.situations['landtrackb3abend'] = new undum.SimpleSituation(
	"<p>Once at Mrs. Wobbles, Mildred had shown her a little trick, how to turn <a hrer='./napkin'>a napkin</a> into a parachute. Perhaps she could try something like this, except using herself.  It was many rotations of her post around the bed before she finally managed to life her body ever so slightly off the sheet.  After several more tries, she gave her back a bit of a bend.  And just like that the slight breeze lifted her off the bed and soon, she was sailing <a href='landtrackb3abend1'>out the window.</a></p>",
	{
		actions: {
			'napkin': function (character, system, action) {
			system.write("<p>A napkin parachute.</p>\
	<p>Take an ordinary paper napkin.  Tie light string to the corners.  Gather the ends of the string and tie that around something light, perhaps a paper clip or small toy.  Then just let it go.  You may want to experiment with different kinds of napkins.  Like the picnic kind with blue and pink prints or the thick, fancy dinner kind.</p>");
	system.animateQuality("strength", character.qualities.strength + 5);
			}
		}
	}
	);

//Floating over the perfect houses
	undum.game.situations['landtrackb3abend1'] = new undum.SimpleSituation(
		"<p>Soon, Lin was floating out the window and over the Land Down Under.  Light as she was,she was in no danger of descending any time soon, unless you chose to. Flying over these perfect homes was even more fun than gliding around them on the track and certainly more enjoyable than staring at them through glass.  For in addition to seeing their flawless uniformity, Lin could marvel at the symmetry of their plans all while gliding on a breeze.  It was as if this whole world had been created for the benefit not of those who lived in it but for those who observed it, who could appreciate and delight in <a href='landtrackb3abend2'>the undisturbed order.</a></p>"
	);


	//Floating over the perfect houses
	undum.game.situations['landtrackb3abend2'] = new undum.SimpleSituation(
		"<p>She continued past the downtown high rises. From this height, she could see could see something unusual. The windows on the buildings were drawn smaller higher up than the ones down below. They had worked awfully hard to make this tiny land seem epic. Soon she was gliding over to the factories with white plumes of smoke scrolling out of their tall smokestacks. But then, the wind began to die down and Lin found herself faced with a choice.  She could land easily on the school playground or, and this seemed a little sketchy, there was a little gap betweent the track and the edge of the Land Down Under.  She could slide down there into the unknown.</p>\
			<ul class='options'>\
				<li><a href='landtrackb3abend2a'>Land gently down on the playground.</a></li>\
				<li><a href='landtrackb3abend2b'>Go all the way off track</a></li>\
				</ul>"
	);

	// Safe Playground
	undum.game.situations['landtrackb3abend2a'] = new undum.SimpleSituation(
	"<p>Beneath her was a school yard, which seemed like a safe enough place to land.  There was plenty of open space and nothing in particular to get caught on.  Lin found it odd that the schoolyard had all the markings of a real one, areas designated for four square and basketball, even hoops, but it was all merely for show because the paper people could not play it.  She thought back to the broken down basketball courts in the schools she had attended over the year.  The black top that would stain her shoes and socks.  She always envied the kids in the private schools with their brand new courts and perfect playgrounds. But here was <a href='landtrackb3abend2a1'>perfection without play.</a> </p>",
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(2);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
			}
		}
);

	
	undum.game.situations['landtrackb3abend2a1'] = new undum.SimpleSituation(
	"<p>As she glided down, she realized a slight short coming in this plan.  For, once she touched the ground, there was no where she could go.  The paper playground was cold on her back and the paper stars above perfectly formed.  But, there was not a breath of wind, and after what felt like an eternity of lying still, staring at the night sky, she fell into what must've been sleep. Just before slipping away, she thought she could see two great eyes looking down as if through glass, and one <a href='landtrackb3abend2a2'>of them winked.</a></p>"
	);


	undum.game.situations['landtrackb3abend2a2'] = new undum.SimpleSituation(
	"<p>After some time passed, Lin awoke -- for that was the only way to describe a gap in awareness of reality -- to find herself being lifted by an elaborate contraption into the air. A bit away from her, a solitary figure in some kind of uniform was seemed to be pressing some buttons.  He or she looked very much like the other paper people, except their arms seemed to be snipped free from his side and could MOVE.  Lin was amazed. But what was more amazing was that she was being moved back onto the track. </p>\
	<p>Once placed back on the track, she was closer to the the worker, who was neither the man nor the woman paper person. A badge on their chest <a href='landtrackb3abend2a3'>read 'track security.'</a></p>"
	);


	undum.game.situations['landtrackb3abend2a3'] = new undum.SimpleSituation(
		"<p>The track that Lin found herself on was below the main track, connected by a kind of onramp, like the kind you used to get on the many freeways in Los Angeles. The Track security guard kept Lin there as the night turned into day and streams of people began to flow toward and into the school.  After about 100 children entered the school, Lin spied a ways down the track a gap in the people.  As it approached, the track security guard tapped a few buttons and then sent Lin up the track and shuffled her into the line right, as it turned out, in the spot she had missed.  Lin had only a moment to notice a number on her spot (818) before she took its place.  She guessed this is how they kept everything so orderly.  <a href='landtrackb3abend2a4'>Everything in its place.</a></p>"
	);


undum.game.situations['landtrackb3abend2a4'] = new undum.SimpleSituation(
	"<p>'Where did you go?' asked Wanda from behind -- so loudly that the other paper people around them winced.<p>\
	<p>'It's a long story,' replied Lin.<p>\
	<p>'Well, don't do it again.  The family -- our family was in a panic.'<p>\
	<p>'A panic? What'd that look like.'<p>\
	<p>'Pretty much the same, except off kilter.  Somehow the mom sped up our track and we were practically spinning around the breakfast table. I thought I was going to toss my paper biscuits.'<p>\
	<p>'Really?'<p>\
	<p>'No,' said Wanda. 'But I could tell she was alarmed. I still can't figure out how you got out of there.'<p>\
	<p>'But before Lin could answer, they found themselves spiralling down a long loop of track only to be deposited in a desk in a classroom just as class was <a href='landtrackd'>about to begin.'</a></p>"
	  );

// Between the tracks -- Bold

undum.game.situations['landtrackb3abend2b'] = new undum.SimpleSituation(
	"<p>She found herself descending into a kind of basement of the land down under, but not the kind she'd seen back in Mrs. Wobbles, the unfinished kind, but the kind of downstairs rumpus room, complete with wood paneled walls, music, a refrigerator, TV, and of course, a couch, on which sat or laid several paper figures, three in fact.  I say, laid, because they had not bent their bodies, so they merely stretched across the couch like planks.</p>\
	<p>Fortunately, there was a gap, on which no one sat -- or laid -- for Lin to land.  Soon, she had joined this group of couch bananas -- for they were too elongated to be considered potatoes, and the couch did bend them slightly, banana-like, watching <a href='./telly>the telly</a> in silence. Interestingly, there was a portion of the track that ran through this area, but there was no way to get on it.  The feeling -- or vibe, if you will -- of this den wasn't so much eerie as hazy, the low noise of the tv and a light film of smoke making it <a href ='landtrackb3abend2b1'>hard to think.</a></p>",
	{
			enter: function (character, system, from) {
				character.qualities.couragearray.push(1);
				var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
				system.setQuality("courage", mostCourage);
			},
		actions: {
			'telly': function (character, system, action) {
	system.write("<p>3D people? People cutting up paper? People setting paper on fire to rock music? Folding paper in strange ways? Rather than a story or a plot, the images just blended together in an endless dreamlike stream that was almost impossible to look away from.</p>");
			}
		}
	}
);

undum.game.situations['landtrackb3abend2b1'] = new undum.SimpleSituation(
	"<p>Soon, a drop of water fell perilously close to her.  I say perilously close because there is nothing more dangerous to a piece of paper than a drop of water.  I know what you're thinking -- scissors, but at least scissors can keep the paperness of the paper. Water, can dissolve the paper into pure pulp.</p>\
	<p>Shifting her attention from the tv to the source of the water, she saw it dripping from the side of the face of the person sitting to her right.  In fact, it had already melted the side of his mouth and so could drip more freely.</p>\
	<p>Lin wasn't sure what disturbed her more, seeing the tear in the perfect paper face or realizing that even as paper people, they were <a href='landtrackb3abend2b2'>somehow full of water.</a></p>"
);

undum.game.situations['landtrackb3abend2b2'] = new undum.SimpleSituation(
"<p>And that is where Lin and Pete stayed the rest of their days, off the track, on the couch, in front of the tv. Lin felt sorry for these people who didn't even have television on demand. But over time, she forgot about that.  And after a while, no one even had enough energy to try <a href='landtrackb3abend2b3'>to use the remote.</a> </p>"
); 

// Add the jetpacks

undum.game.situations['landtrackb3abend2b3'] = new undum.SimpleSituation(
	"",
	{
		enter: function (character, system, from) {
			system.write("<p>And this was life -- or the offtrack equivalent. Sitting. Staring. Slugging. </p>");
			if (character.qualities.jetpack >= 1) {
				character.sandbox.whereto = from;
				system.write("<br/><em><p class='transient'>You don't want to be here forever do you? You could use a jetpack and make a different choice.</em></p>");
				system.write("<p class='transient'><ul class='options'>\
			<li><a href='./jetpackgo' class='once' onClick='_gaq.push([\"_trackEvent\",  \"Spyeye\", \"Jetpack\", \"used\"]);'>Use Jetpack?</a></li>\
			<li><a href='landdownentera'>Don't</a></li></ul></p>");
			}
			else {
				system.write("<p>And since you have no more jetpacks, I guess we'll just have to leave it there. All you can think is, there must've been another way. <a href='landownfinalend'>Hope you enjoyed the path you took!</a></p>");
			}
		},
		actions: {
			'jetpackgo': function (character, system, action) {
				system.setQuality("jetpack", character.qualities.jetpack - 1);
				system.write("<p class='transient'>When the big dial is turned to 'Launch,' the jetpack rumbles to life, spewing white steam of smoke and rattling like a snoring pig. Lin  managed to get it on like a backpack BEFORE pressing 'GO.'</p>\
				 <p class='transient'>3-2-1</p>\
				 <p class='transient'>The jetpacks rocketed Lin, zipping over the track.  Eventually, she was above the smog and in a clear blue sky.</p>\
				 <p class='transient'>A message on the strap flashes: Approaching Jump</p>\
				 <p class='transient'>What could this mean? Jump where? Well, only <a href='landtrackb3abend2'>one way to find out!</a></p>");
			}
		}
	}
	);

// Inflating
undum.game.situations['landtrackb3a1'] = new undum.SimpleSituation(
	"<p>When Lin was young, she had read a book about a boy who was completely flattened.  When she read it, she decided that if that if it ever happened to her, she wouldn't take it lying flat but would solve the problem by merely inflating herself.  Little did she know that she'd have the chance to try that out. </p>\
	<p>So, summoning all of her concentration, she began to try to blow air into her flattened cheeks.  You see, the flattened people still breathed.  Don't ask me how. That would require an additional set of volumes just to explain the <a href='landtrackb3a2'>anatomy of paper persons.</a></p>"
	);

undum.game.situations['landtrackb3a2'] = new undum.SimpleSituation(
	"<p>At the same time that she blew into her cheeks, she clenched her mouth tight, so that the air could inflate her cheeks.  At first, nothing happened.  What would you expect?  You see, to inflate something you need something that has three dimensions but is just flattened out or deflated.  Let me ---</p>\
	<p>What?  Nope, I was wrong.</p>\
	<p>There she goes.  It started with a little bulge in her big toe on her right foot.  Now imagine trying to get any air all the way down there. If you've ever tried to blow up those long balloon animal shapes, you know what I'm talking about. It's like playing a trumpet through a straw, or <a href='landtrackb3a2'>so I'm told.</a></p>"
);


undum.game.situations['landtrackb3a2'] = new undum.SimpleSituation(
	"<p>Anyway, the toe bulged a bit, then deflated -- actually making a little high pitched whine as though Lin had let out a tiny fart through her mouth.  Rein it in.</p>\
	<p>On her second attempt, she slightly inflated her left calf.  But again, the deflating and a slightly lower pitched whine.</p>\
	<p>Now, with a spike in determination, she took her deepest breath yet -- again, forget for a moment the fact that humans must extend their bodies to take a deep breath -- and Lin was able to blow out her belly.  She looked like one of those dads who are still skinny as when they were teenagers except <a href='landtrackb3a3'>for their bellies.</a></p>"
	);
	
	
undum.game.situations['landtrackb3a3'] = new undum.SimpleSituation(
	"<p>Now, to keep that from deflating, she did something unusual.  Rather than letting the air out, she took another quick inhale that sent the bulge back into her butt and still kept her belly full.  Big Belly. Big Butt. Perfect, thought Lin.  And eventually she would have to exhale -- or so she imagined.</p>",
	{
		enter: function (character, system, from) {
			system.write("<p><a href='landtrackb3a3b'>Try a huge breath to become a ball.</a></p>")
			if (character.qualities.strength >= 30){
				system.write("<p><a href='landtrackb3a3a'>Try making yourself into a balloon animal</a></p>");
			}
		}
	}
);

// Beach ball
undum.game.situations['landtrackb3a3b'] = new undum.SimpleSituation(
	"<p>With a bit more air, Lin had inflated herself completely.  Because there were no real cuts in the paper, she had essentially blown herself into what could only be called a beach ball -- or perhaps more accurately, a beach sausage -- like those little hot dogs they sell -- cocktail weiners, might be <a href='landtrackb3a3b1'>a more accurate name.</a></p>"
);

undum.game.situations['landtrackb3a3b1'] = new undum.SimpleSituation(
	"<p>This would have been a truly humiliating look for a girl in her early teens -- she could hear the snipes of various classmates she'd had -- but as a means of escaping the house, it was actually quite effective, and to be frank, quite comical. Even she was laughing too hard to be self-conscious. </p>\
	<p>Within moments of achieving any kind of circumference, Lin was rising off the bed and thanks to a light breeze floating <a href='landtrackb3a3b2'>out of the window.</a></p>"
);
	
undum.game.situations['landtrackb3a3b2'] = new undum.SimpleSituation(
	"<p>Well, <em<floating</em> floating conveys too graceful an image, for along her course she boinged against the walls and occasionally the ground and then out the window.</p>\
	<ul class = 'options'>\
		<li><a href='landtrackb3a3b2bounce'>Bounce</a></li>\
  		<li><a href='landtrackb3a3b2brace'>Brace for impact</a></li>\
 		<li><a href='landtrackb3a3b2scream'>Scream</a></li> \
		 </ul>"
		);

		//Bounce bold
undum.game.situations['landtrackb3a3b2bounce'] = new undum.SimpleSituation(
	"<p>Now to float out a window two stories up even in a paper world can be quite terrifying, but as a giant bouncing beach blimp -- okay, that's the name I'm sticking with -- it was actually rather fun.  You may not believe me, but that is because you have never truly bounced.</p>\
	<p>As she came down upon a large backyard, she hit the ground and -- then, a strange thing happened, her balloon body squashed a bit and then bounced her <a href='landtrackb3a3b2land'>into the air.</a></p>",
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(1);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
			}
		}
);



	//Brace for impact: -- safe
	undum.game.situations['landtrackb3a3b2brace'] = new undum.SimpleSituation(
	"<p>Bracing for impact is often a good idea, like when you're being slid into a shelf by an agressive librarian -- sorry, that happens to books all the time.  But the problem with that, especially when you are a large balloon is you miss out in the pleasure of the bounce and somewhat slow <a href='landtrackb3a3b2bounce1'>your own progress.</a></p>",
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(2);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
			}
		}
);


//Scream
undum.game.situations['landtrackb3a3b2scream'] = new undum.SimpleSituation(
	"<p>'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAH--' breath -- 'AAAAAAAAAAAAAAH!' went Lin.</p>\
	<p>There is one thing that can be said with certainty about screaming in a crisis.  It is a guaranteed way	to make a lot of noise.  It also can help you release a little emotion, and, if you are inflated into a giant beach ball, you may also release a bit of the air you need to stay bouncy. So, as Lin connected with the ground of the land down under, she didn't have nearly as much air as she would have liked to truly cushion her fall.  The result was more of an 'ouch' than an 'ooof' in what might have been a 'wheeee,' to put it mildly.</p>\
	<p>On her way back up, she worked to inhale and inflate herself back up and decided that in the next bounce, she would <a href='landtrackb3a3b2bounce1'>just go with it.</a></p>",
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(3);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
			}
		}
);


undum.game.situations['landtrackb3a3b2bounce1'] = new undum.SimpleSituation(
	"<p>It turns, she bounced to the ground and then back up again, bounding over the little white fences and sometimes whole buildings, depending on the angle and her speed and whether or not a little wind was blowing. Soon she got the hang of it and could more or less direct her progress.</p>\
	<p>At some point as she floated above the homes an especially pretty but still very uniform area of the houses, she <a href='landtrackb3a3b2land'>found herself descending.</a></p>"
	);



undum.game.situations['landtrackb3a3b2land'] = new undum.SimpleSituation(
	"<p>When she came to a rest on the ground, she looked about. In this dark area of the land away from the houses and buildings, all she could see was construction. They were building segment after segment of new track as part of a massive expansion -- that would go well outside of the Tangerine House and extend into the whole neighborhood. But before she could roll around and explore, she was seized by a group of paper people. Were they police?  Maintenance? She couldn't tell. But from their curt comments ('Who's this?' 'Someone's gone off') she got the sense that the powers that be did not like people going off track. They blindfolded here, deflated her, and returned <a href='landtrackb3a3a3'>her to her bed.</a></p>"
); 


// Balloon animal 

undum.game.situations['landtrackb3a3a'] = new undum.SimpleSituation(
	"<p>Lin could make herself into a balloon animal. Sure, why not? In the land up above, Lin was actually quite talented at making balloon animals.  She had learned how <a href='landtrackb3a3aballoon'>in one of the foster homes she'd lived in</a>.  How much more complicated could making oneself into a balloon animals be?  </p>\
	<p><em>Think about that sentence for a little while. The answer should be more than <a href='landtrackb3a3a1'>a little obvious.</em></a></p>"
);


	undum.game.situations['landtrackb3a3aballoon'] = new undum.SimpleSituation(
	"<p>Balloon animals.  Thinking back to her childhood, she remembered one party at one of the many foster homes she was in.  A teenage girl, pimply, awkward, with limbs too long for her slight frame, and too big in strange places, big shoulders, long feet, incredibly bony knees, sat in a foldout chair that was far too small for her. Her hair was long and stringy, a bit greasy, hanging in expertly drawn curtains, showing only her mouth and chin.</p>\
	<p>She sat with her mouth agape, staring out at the party, wishing she could vanish into the seat.  As she sat there, one of the younger kids, maybe 5 or 6, waddled over with a pile of balloons and dropped <a href='landtrackb3a3aballoon1'>them in her lap.</a></p>"
	);
	
	
	undum.game.situations['landtrackb3a3aballoon1'] = new undum.SimpleSituation(
		"<p>At first, the girl brushed them off with long, knobby fingers.  But as the boy deposited them for a second time, she drew one curtain back to eye him.  There he stood unblinking, wide-eyed as a puppy, smiling at her expectantly with an open-mouthed grin.</p>\
		<p>The girl promptly dropped the curtain of her hair again, folding her arms across her chest and sinking heavily back into the chair, which distended from too much weight. It's not that she was too heavy, but it was too weak, which of course, led to the little mesh ribbons sbroinging, and her <a href='landtrackb3a3aballoon2'>butt smashing through.</a></p>"
		);

undum.game.situations['landtrackb3a3aballoon2'] = new undum.SimpleSituation(			
		"<p>The sight of that gangly girl knees higher than her head, but sunk clean through the chair, arms flailing, hair flopping was too much for the boy who laughed and giggled.  And it was his laughter, not mean or pointed, not harsh or judgmental, genuine infectious laughter that overcame her in that whole moment that should have been embarrassing.</p>\
		<p>And so it was that from her little quiet corner, underneath the picnic bench where she had been hiding, that Lin watched the technique of twisting off balloon animals.  And it was there too that she was first introduced to the concept of the spontaneous joy of just being in it.  And she had forgotten all of that <a href='landtrackb3a3a1'>until right now.</a></p>"
		); 


undum.game.situations['landtrackb3a3a1'] = new undum.SimpleSituation(
	"<p>If you were going to make yourself into a balloon animal, you might find being made of paper -- especially without organs and bones to speak of -- makes it a bit easier.</p>\
	<p>What kind of animal should she choose?</p>\
		<ul class='options'>\
			<li><a href='landtrackb3a3a1a'>a lady bug</a></li>\
			<li><a href='landtrackb3a3a1b'>a giraffe</a></li>\
			<li><a href='landtrackb3a3a1c'>a snake</a></li>\
			</ul>"
			);

//A Lady bug.
undum.game.situations['landtrackb3a3a1a'] = new undum.SimpleSituation(
			"<p>Now, a lady bug at first seemed an impossible shape for a human.  She could inflate her head, she imagined, but the rest of her body would have to dome out in a kind of half sphere.   She decided she could forget about the wings because, well, how could she do that?  I'm up for suggestions. In any event.  With a lot of effort, she managed to get some air from her belly into her butt, and then it was just a matter of continuing to inflate butt-outward and not to let any air to circulate forward.  At one point, the air from her butt, threatened to redistribute to her whole body at which point, she ceased inflating, which did make her look more like a scone or flattish muffin, but good enough, she decided. At least she did manage to make her head into a semi-sphere.  The head <a href='landtrackb3a3a1join'>was quite convincing.</a></p>",
			{
				enter: function (character, system, from) {
					character.sandbox.balloon='lady bug';
				}
			}	
		);
			
		
//A Giraffe
undum.game.situations['landtrackb3a3a1b'] = new undum.SimpleSituation(
			"<p>A giraffe? Well, if she had to be an animal, why not a giraffe?  And so she proceeded to twist herself.  Well, not really twist herself, since she could not move her arms or any part of her body, but to seal off parts of herself, to cinch part of herself tight. This, I warn you, took epic concentration. I don't think you should, as they say, try this at home.  Soon, she had managed to direct most of the air to her neck, and only a very little bit of air to her abdomen (her belly, more or less), her butt, and her legs.  Okay, she still only had two legs, so she looked maybe a bit more like a person with <a href='landtrackb3a3a1join'>a very long neck.</a></p>",
			{
				enter: function (character, system, from) {
					character.sandbox.balloon='giraffe';
				}
			}	
		);

		
//A Snake
undum.game.situations['landtrackb3a3a1c'] = new undum.SimpleSituation(
			"<p>A snake? Why not make a snake?  This seemed like a perfectly do-able shape.  She merely needed to get air evenly distributed throughout her whole body.  The problem was that in spite of not being separated, her legs and arms were different chambers, if you will. So the best she could do was inflate them more or less equal with the rest of her body.  The effect was that she looked like an inflated person.  However, the big break through came when she was able to increase the amount of air in her length.  Now in a human, she'd be stretching her spine apart, as though on a rack.  In a paper person, or at least a Land Down Under paper person, she was able to extend hereself to a length that made her if not snake-like, at least worm or <a href='landtrackb3a3a1join'>fully-cooked noodle like.</a></p>",
			{
				enter: function (character, system, from) {
					character.sandbox.balloon='snake';
				}
			}	
		);


//Rejoin -- all balloons
undum.game.situations['landtrackb3a3a1join'] = new undum.SimpleSituation(
	"",
	{
		enter: function (character, system, from) {
	system.write("<p>When she was flat, she had noticed a bit of a breeze in the land down under caused, she guessed by the continuous flow of the track.  Now as a three dimensional balloon animal, she felt the wind on her surface and soon found herself lifted by it and out the window.</p>\
	<p>You may have seen giant balloon animals in a holiday parade floating over a city, and indeed Lin felt a little bit like that, except, you must understand, she was not giant. She was essentially a paper person-sized balloon " + character.sandbox.balloon + ".  While that didn't make floating any less fun it did mean she was quite a bit harder to see, if you were spying for her -- which someone was.  For down on the track, evenly spread out, maybe 25-30 people posts apart were a different kind of paper person, these all wearing the same uniform.</p>\
	<p>From this height, she could not tell if they were police or maintenance.  But they did seem to be examining the area, as their posts rotated them slowly as <a href='landtrackb3a3a2'>they circulated on the track.</a></p>");
			}
		}	
);

// Spotting them could also be a mix-in. 

undum.game.situations['landtrackb3a3a2'] = new undum.SimpleSituation(
	"<p>There is a hilarious freedom at being a giant balloon animal, especially when you are floating through a neighborhood of identical paper homes in a miniature world underneath a tangerine house. I'm thinking you're just going to have to take my word for it. </p>\
	<p>But if you want to know what makes it even more bizarre -- imagine being spotted by someone.</p>\
	<p>As her movement slowed a bit, from a slight lack of wind. Lin found herself right beside a window of one of the homes.  But rather than sleeping, this particular paper child had found her way to the window.</p>\
		<ul class='options'>\
			<li><a href='landtrackb3a3a2a'>Say a meek 'hello'</a></li>\
			<li><a href='landtrackb3a3a2b'>Give a safe wave</a></li>\
			<li><a href='landtrackb3a3a2c'>Say, 'What's your name?'</a></li>\
			</ul>"
	);  

// Hello -- Timid
	undum.game.situations['landtrackb3a3a2a'] = new undum.SimpleSituation(
		"",
		{
			enter: function (character, system, from) {
		system.write("<p>Hearing a giant " + character.sandbox.balloon +  " say hello is actually rather -- how do the kids say it -- freeky.<p>\
		<p>In frightened reply, the child said, 'Oh, that's cool. I like the animals. I didn't know <a href='landtrackb3a3a3'they could do that.'</a></p>");
			character.qualities.couragearray.push(3);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
			}
		}
	);


// Give a Wave -- Safe
undum.game.situations['landtrackb3a3a2b'] = new undum.SimpleSituation(
	"",
	{
		enter: function (character, system, from) {
	system.write("<p>Upon seeing the balloon " + character.sandbox.balloon + " wave, the stunned boy replies, 'Wow. Things can be alive. This child will grow up to make friends of all sorts of imaginary creatures -- basically destining themselves <a href='landtrackb3a3a3'>to become a writer.</a></p>"); 
		character.qualities.couragearray.push(2);
		var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
		system.setQuality("courage", mostCourage);
			}
		}
);
	

// Bold Say something
undum.game.situations['landtrackb3a3a2c'] = new undum.SimpleSituation(
	"",
	{
		enter: function (character, system, from) {
    system.write("<p>'Hi, what's your name?' said the balloon "+ character.sandbox.balloon + ".</p>\
	<p>'My name is Timmy.'</p>\
	<p>'Oh, hi, I'm Lin.'</p>\
	<p>And Lin's courage, gave the boy courage to say, 'It's fun to see something different for once.'</p>\
	<p>'Yeah, there's so much more once you leave the track.'</p>\
	<p>'Leave the track?' said Timmy.</p>\
	<p>'Well, like by staying up at night and peering out the window.'</p>\
	<p>'Oh, right,' said the boy. 'But I never go anywhere.'</p>\
	<p>'You haven't yet,' she said.  'But now you know it's possible.' And with that, the breeze began to pick and glide Lin in the direction of her house.</p>\
	<p>'Gotta go, said Lin. I hope to see you again, Timmy. Remember, there's a lot more possible than what you see on the track.'</p>\
	<p>As Lin floated away she had a feeling <a href='landtrackb3a3a3'>she'd see him again.</a></p>");
	character.sandbox.landmettimmy = true;
		character.qualities.couragearray.push(1);
		var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
		system.setQuality("courage", mostCourage);
		}
	}
);


// Balloon animal wraps up:

undum.game.situations['landtrackb3a3a3'] = new undum.SimpleSituation(
	"<p>Fun as it was to be a balloon animal, the incesssant whir of the track kept humming in her ear, beckoning her toward some destiny. She couldn't just bail.  That wasn't her.</p>\
	<p>So, Lin floated her way back into her room -- however, she could not quite fit in through the window.</p>\
	<p>Exhaling deeply, she let out her air and unwound.</p>\
	<p>Squeezing herself through the window, part of her got caught, and as the rest of her corkscrewed through, she untangled hereself.</p>\
	<p>And finally she was back in the bed, flat as a postcard from her own adventure, as the post circled and circled until she fell into something that could <a href='landtrackb4'>pass for sleep.</a></p>"
	); 

// The next morning

undum.game.situations['landtrackb4'] = new undum.SimpleSituation(
	"<p>The next morning, if you could call it that, Lin found herself moving again around her room into and out of the bathroom, down the stairs, and then around the table again.  She was amazed to realize that she must have fallen asleep because there was at least one segment of time that she couldn't remember. Had she <a href='./dream' class='once'>dreamed?</a> How she slept or for how long was impossible to tell since every moment looked exactly the same, but the counter in her room did say 128, which made her feel as if she had only slept just a <a href='landtrackb4a'>very short time.</a></p>",
	{
		actions: {
			'dream': function (character, system, action) {
				system.write("<p>Yes, she had the faintest recollection of a dream, being three dimensional again and seeing Mrs. Wobbles who said, 'No, you can't come back yet.  Just keep your eyes and ears open.' And then she was gone.</p>");
				system.animateQuality("strength", character.qualities.strength + 5);

			}
		}
	}
);




undum.game.situations['landtrackb4a'] = new undum.SimpleSituation(
	"<p><p>But no one looked any worse for the wear, as they all wore their exact same smiles, same clothes, same, well, everything.  Only the food on the table had changed, now offering breakfast cut-outs, stacks of waffles and pancakes, perfectly ripe fruit, puddings and jams, yogurts, and <a href='landtrackb4b'>even some nuts.</a></p>"
);

undum.game.situations['landtrackb4b'] = new undum.SimpleSituation(
	"<p>Lin wondered where this food came from, until, in a reflection off a tinfoil mirror in the living room, she saw the bottom of the table to which was stuck the food from last night's meal.  It was still there.  They must just flip the table for morning <a href='landtrackb4c'>and night meals!</a></p>"
);

// Perhaps some attempts to get away from the table					
undum.game.situations['landtrackb4c'] = new undum.SimpleSituation(
	"<p>After a few cycles around the table, the children were drawn out of the dining room and gliding on their way out the door past the paper mother who again seemed to be eyeing Lin suspiciously, though of course, her eyes remained perfectly still.</p>\
			<p>'Ffffeew, that was close. Glad we made it,' said Lin.</p>\
			<p>'Maybe that time, but you don't realize how often we're going to have to go through that.'</p>\
			<p>For the first time, Lin felt a slight pang of concern about the monotony of gliding along the same <a href='landtrackc'>track all day.</a></p>"
);


// DOWNTOWN Track C			
undum.game.situations['landtrackc'] = new undum.SimpleSituation(
	"<p>But she hardly had time to worry when they entered the downtown -- a bright, beautiful city, lined with silver skyscrapers and parks, all perfectly aligned in a kind of magical grid.  Each building stood straight, as perfectly parallel lines ran up along the sides. They seemed infinitely tall.</p>\
			<p>'They draw the windows smaller as you go up. It's an illusion,' explained Wanda.</p>\
			<p>Still, Lin marveled at the sight. </p>\
			<p>Inside the windows, she could see the people, women and men, circling in <a href='landtrackc1'>their offices.</a></p>"
);


// Questions could have choices

undum.game.situations['landtrackc1'] = new undum.SimpleSituation(
	"<p>'What do they do? Do they have jobs?' asked Lin.</p>\
			<p>'Oh, yeah,' said Wanda.  'Most of them work in the workshops.'</p>\
			<p>'Doing what?' asked Lin, who had never seen anything added to the scenes.</p>\
			<p>'Mostly cutting and coloring,'replied Wanda.</p>\
			<p>'Cutting and coloring what?' </p>\
			<p>'More people,' said Wanda in a matter of fact tone as though she were telling Lin that sky was blue.  And indeed it was crystal blue the likes of which no Angeleno had ever <a href='landtrackc2'>seen above them.</a></p>"
);

//Add something about how this process works, they are strapped on pistons			

undum.game.situations['landtrackc2'] = new undum.SimpleSituation(
	"<p>Before they left the city, Lin caught sight of another factory, complete with hand-drawn smoke rolling up out of the smokestacks like paper towels or toilet paper on a giant rod she could not see.</p>\
	<p>'What do they make there?' she asked, gasping at the size of the factory and at how clean it was.  Nothing like the factory where one of her foster moms had worked.</p>\
	<p>'Track.  More track.  You didn't think this was all there was, did you?'</p>\
	<p>Lin shrugged.</p>\
	<p>'They're constantly expanding their track. It's how they make their world bigger so they can add more people and places.'</p>\
	<p>If Lin could open her mouth, she would have gaped like Peter.  <a href='landtrackc3'>Speaking of which...</a></p>"
);

undum.game.situations['landtrackc3'] = new undum.SimpleSituation(
	"<p>But she had no time to follow that thought because no sooner did she close her mouth again that she found them swirling on a track, like water down a toilet or coins around the donation spiral at the science museum, down into a what looked like and indeed was a school building where she found herself deposited at a desk in a row of children doing a flag salute -- or at least standing <a href='landtrackd'>before a flag.</a></p>",
	{
		enter: function (character, system, from) {
			system.setQuality("distance", "2/5");
			system.animateQuality("complete", character.qualities.complete + 20);
		}
	}
);


// SCHOOL Track D
undum.game.situations['landtrackd'] = new undum.SimpleSituation(
	"<h1>Flattening the Curve</h1>\
		<p>Lin rotated around the room once before she found herself plopped off the track into a desk in the picture-perfect classroom, the track spinning almost noiselessly around the room like a ticking clock.  All the rows were perfectly straight.  Each child's work hung from the board with a perfectly drawn star. The room, perfectly decorated, with <a href='./landmousepoem2' class='transient'>a perfect poem</a> hanging beneath a perfectly ruffled flag. The children were perfectly still and everyone was perfectly quiet. (<em>I may need to find another word for perfect before I <a href='landtrackd1'>wear this word out!</a>)</em></p>",
	{
		actions: {
			'landmousepoem2': function (character, system, action) {
				system.setCharacterText("<h1>Poetry Power-up</h1><p>'The Spotted Mouse, part II' <br/>by Genevieve Marino<br/>Excellent find!</p>");
				system.write("<center><h3>Poetry Power-up</h3></center>\
       <center>The Spotted Mouse</center>\
      <center>Part II</center>\
       <center>by Genevieve Marino</center><br/>\
<p>The spotted mouse was all in distress<br/>\
So he ran from his hole to take a breath<br/>\
As he sat and stared he saw a world paper thin<br/>\
All of the people looked the same within</p><br/>\
<p>Drawn to this world, he slowly moved toward it<br/>\
Maybe he'd be the same if he kept moving forward<br/>\
He went into this new world and was transformed<br/>\
He became something new, found a new paper form</p><br/>\
<p>As he looked at himself he could see no more spots<br/>\
He was not different below or even on top<br/>\
Filled with new hope he chose to explore<br/>\
Until he found out he was stuck to the floor</p><br/>\
<p>The mouse slowly found he was not recognized<br/>\
He wasn't any different, which helped him realize:<br/>\
The part of him that made him strange<br/>\
Had been the special thing he shouldn't change</p><br/>");
				system.animateQuality("skill", character.qualities.skill + 7);
				system.write("<p><em>You have found a poem! Excellent! Gather up poems wherever you find them! They <a href='landtrackd1'>cast powerful spells!</a></em></p><br/>");
				if (character.qualities.skill > 20) {
					system.write("<p>You have now earned enough Poetry Power-ups to purchase another 2 Jetpacks.  They will cost you 30 Poetry Power-ups. Would you like to trade for them?</p>\
   		<ul class='options'>\
   		<li><a href='landmouseyespacks2' class='transient'>Yes, I wish to trade.</a></li>\
   		<li><a href='landmousenopacks2' class='transient'>No, I do not.</a></li>\
   		</ul>");
				}
			}
		}
	}
);


undum.game.situations['landmousenopacks2'] = new undum.SimpleSituation(
	"<p>Okay, no problem. <a href='landrisk3'>Perhaps next time.</a></p>"
);



undum.game.situations['landmouseyespacks2'] = new undum.SimpleSituation(
	"<p>Excellent, you now have 2 more jetpacks for use for traveling back to a previous key choice.  Let's get <a href='landrisk3'>back to the story.</a></p>",
	{
		enter: function (character, system, from) {
			system.animateQuality("skill", character.qualities.skill - 30);
			system.animateQuality("jetpack", character.qualities.jetpack + 2);
		}
	}
);


// Choice: speak up or say silent.
// Choice: Ask about the number 10 being too easy
// Choice: Ask about the students who are falling behind. 

// 	If you don't say anything....
// Lin gets bored and falls asleep...
// The teacher sends her out and she gets to talk to the queen 
// Who tells her rebellion is good. 

undum.game.situations['landtrackd1'] = new undum.SimpleSituation(
	"<p>The day's instruction, if you could call it that, scrolled across the board from a roll of paper towels, with a lesson about how to count to 10.</p>\
	<p>Despite the lesson being so simple, at least to Lin, several of the students seemed to be struggling with it.  She saw tiny, almost imperceptible frowns on their faces.  To be honest, no facial expression was beyond Lin's notice because she had experienced so painfully her own.</p>\
		<ul class='options'>\
			<li><a href='landtrackd1easy'>Demand a more challenging lesson</a></li>\
			<li><a href='landtrackd1hard'>Raise a hand to ask about those falling behind</a></li>\
			<li><a href='landtrackd1quiet'>Say nothing, this is their system after all</a></li>\
		</ul>"
);



// too easy -- bold
undum.game.situations['landtrackd1easy'] = new undum.SimpleSituation(
			"<p>'Count to 10?' Lin caught herself saying before she could stop herself.</p>\
			<p>'Excuse me?' asked the teacher as the paper towel suddenly stopped rolling across the board.</p>\
           <p>'You're only teaching us to count to 10?'</p>\
		  <p>'Why, of course,' said the teacher somehow managing to make her unmoving eyes look <a href='./condescending' class='once'>condescending.</a> 'That's all you'll ever need.'</p>\
			<p>'What about addition? Subtraction? Multiplication? Fractions?' thought Lin, though she secretly hated fractions. A cough from Wanda made her stay silent.</p>\
			<p>'We need only to count to and no more than ten: 10 items at the grocery store, 10 pieces of clothing, 10 sheets of our most precious possession, paper itself! You see, 10 is the flattest number <a href='landtrackd2'>in the world.</a></p>",
			{
				enter: function (character, system, from) {
					character.qualities.couragearray.push(1);
					var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
					system.setQuality("courage", mostCourage);
				},
			actions: {
				'condescending': function (character, system, action) {
					system.write("<p>Condescending? Oh, yes, that. Well, have you ever had someone, usually someone older than you who often thinks they know more than you do talk to you as though you were a child -- even if you are a very smart child?</p><p>What do you mean, I keep doing that?  Paaaaa-lease. I am just trying to be a more open book.</p>");
					system.animateQuality("strength", character.qualities.strength + 5);
				}
			}
		}
);

// leaving students behind  -- safe
undum.game.situations['landtrackd1hard'] = new undum.SimpleSituation(
	"<p>'Teacher,' she asked, raising a hand, 'Not all of these children can keep up.'</p>\
	<p>But the teacher's face grew markedly cross, folding in unpleasant creases. 'Well, that is, as they say, their problem. The track waits for no one.' And, Lin knew from her tone that was the end of that discussion.</p>\
		<p>'Oh,' replied Lin, and a school bell rang and the <a href='landtrackd2'>day was done.</a></p>",
		{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(2);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
			}
		}
);



// Say nothing -- Timid
undum.game.situations['landtrackd1quiet'] = new undum.SimpleSituation(
	"<p>For some students the lesson was clearly too hard and for others far too easy, but Lin thought it best not to make any waves. Education in the land down under was like the continuously scrolling chalkboard -- it neither sped up nor slowed down, never skipped ahead nor took a pause. You either kept pace or did not, the system was completely indifferent -- which in some twisted way maybe counted as equality. Education <a href='landtrackd2'>here was blind.</a></p>",
	{
		enter: function (character, system, from) {
		character.qualities.couragearray.push(3);
		var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
		system.setQuality("courage", mostCourage);
		}
	}
);



undum.game.situations['landtrackd2'] = new undum.SimpleSituation(
	"<p>As the school day came to a close, something else troubled Lin.  Just before they were whisked out of the flat classroom, she caught sight of something scurrying by, large and fuzzy and, <a href='landtrackd3'>well, three-dimensional!</a></p>"
);

// Ant E Mouse
undum.game.situations['landtrackd3'] = new undum.SimpleSituation(
	"<p>'Haven't you ever seen an Ant E Mouse,' came a voice behind her as they circled around the playground.</p>\
			<p>At the next bend, the girl on the inner track caught up to her and something about her struck Lin.  While her basic look was the same as everyone else in this land, her arms seemed to be missing some of the paper, as though it had been snipped off.</p>\
			<p>'What's an Ant E Mouse?'</p>\
			<p>'Oh, you might know them as ticklebugs. They're tricky.  Watch out or it'll sneak up and tickle you.'</p>\
			<p>'You're kidding,' said Lin.</p>\
			<p><a href='landtrackd4'>'Nope.'</a>"
);

undum.game.situations['landtrackd4'] = new undum.SimpleSituation(
	"<p>They continued to move in laps around the playground, surely the most boring of recesses ever.  Lin was sometimes in front of and sometimes behind the girl who said her name was Anna.</p>\
			<p>'You look different,' said Lin after a while.</p>\
			<p>'You're one to talk,' said Anna.  'What's with the sticker on your head?'</p>\
			<p>'Oh that,' Lin would have blushed if the paper had allowed it. 'I needed to set myself apart.'</p>\
			<p>'Huh.  You a regular rebel?' asked Anna.  'One of those trackless types.'</p>\
			<p>'Trackless?' <a href='landtrackd5'>asked Lin.</a>"
);

undum.game.situations['landtrackd5'] = new undum.SimpleSituation(
	"<p>'Yeah, they call themselves the Folders. Supposedly, they figured out how to change tracks at switch points and have secret meetings where they learn different ways of folding things.'</p>\
			<p>Lin remembered the origami she had seen in her bedroom.</p>\
			<p>'And they get parts of their arms cut off?' asked Lin.</p>\
			<p>The girl did not respond.  But the next time she approached, the girl whispered, 'After school through the park to the old binding factory.'</p>\
			<p>And then she was whisked off toward her row of lockers for the end <a href='landtrackd5a'>of day routine.</a></p>"
);

undum.game.situations['landtrackd5a'] = new undum.SimpleSituation(
	"<p>On the way out of the building, Lin spotted something extraordinary. Finally, someone who looked different.  She was about the same size as everyone else, but she wore a crown and majestic robes.</p>\
			<p>She was accompanied on either side by two typical paper women who seemed to stand straighter and taller, like guards <a href='landtrackd5a1'>of some sort.</a></p>\
			<center><img src='media/games/tutorial/images/landdown2_440.png' alt='the students glide past the Queen of hearts'></center>"
);

undum.game.situations['landtrackd5a1'] = new undum.SimpleSituation(
	"<p>'It's the Queen of Hearts,' whispered Wanda.</p>\
			<p>'The who of what?' asked Lin.</p>\
			<p>'Look at the shape of her face!' And indeed it was shaped like a perfectly drawn heart.  Well, not a heart, heart, like the kind in your body, but that <a href='./hearts' class='once'>cute little shape</a> of double rounds and pointy bottom that you find <a href='landtrackd5a1a'>in a deck of cards.</a></p>",
	{
		actions: {
			'hearts': function (character, system, action) {
				system.write("<p>I have always found it strange that people think the perfect shape for a woman's face is the heart -- the symbol, I mean, not the actual blobby fist inside human chests. In that sense, the Queen's face was beyond perfect because it was exactly the shape of love.  And so her face was truly ironic, for love, romantic love for the King, had long since fallen from its perfect point.</p>");
				system.animateQuality("strength", character.qualities.strength + 5);

			}
		}

	}
);




undum.game.situations['landtrackd5a1a'] = new undum.SimpleSituation(
	"<p>Before Lin could ask anything further, she was in front of the Queen who was greeting all of the students so graciously.</p>\
			<p>'Good day, good day,' she repeated.  Though her smile was bright, something in her eyes made Lin think she was in pain or unhappy?</p>\
			<p>'Why does the Queen greet all of the students?' Lin asked Wanda who was <a href='landtrackd5a2'>behind her again.</a></p>"
);

undum.game.situations['landtrackd5a2'] = new undum.SimpleSituation(
	"<p>'I don't know.  No one's been able to explain it to me.  Apparently, she's been doing it since she got divorced from the King.'<p>\
	<p>'Ahem,' came a voice, and Lin was startled to see the Queen and her entourage travelling beside her on some sort <a href ='landtrackd5q'>of rolling platform.</a></p>"
);

// A little chat with the Queen. 

undum.game.situations['landtrackd5q'] = new undum.SimpleSituation(
	"<p>'You're not from here, are you?' said the Queen, still staring intently at Lin.</p>\
	<ul class='options'>\
		<li><a href='landtrackd5q1'>Sure I am</a></li>\
		<li><a href='landtrackd5q2'>How can you tell?</a></li>\
		<li><a href='landtrackd5q3'>You mean the school?</a></li>\
	</ul>"
	);

	//Timid
	undum.game.situations['landtrackd5q1'] = new undum.SimpleSituation(
		"<p>'Sure I am,' said Lin, trying to keep her face even more expressionless than it already was.</p>\
		<p>'Lying?' said the Queen, 'That's not true to your cut.  Are you <a href='landtrackd5qa'>afraid of me?</a></p>",
		{
			enter: function (character, system, from) {
				character.qualities.couragearray.push(3);
				var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
				system.setQuality("courage", mostCourage);
			}
		}
);

	//Bold
	undum.game.situations['landtrackd5q2'] = new undum.SimpleSituation(
		"<p>'How can you tell?' asked Lin.</p>\
		<p>'When you've seen everyone in a kingdom, you notice when someone stands out,' <a href='landtrackd5qa'>replied the Queen.'</a></p>",
		{
			enter: function (character, system, from) {
				character.qualities.couragearray.push(1);
				var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
				system.setQuality("courage", mostCourage);
			}
		}
);


	//Safe
	undum.game.situations['landtrackd5q3'] = new undum.SimpleSituation(
		"<p>'You mean the school?' asked Lin.</p>\
		<p>'What a silly thing to say,' said the Queen, clearly losing some respect for Lin. 'I didn't take you to be a girl who wastes her <a href='landtrackd5qa'>words with games.</a></p>",
		{
			enter: function (character, system, from) {
				character.qualities.couragearray.push(2);
				var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
				system.setQuality("courage", mostCourage);
			}
		}
);


undum.game.situations['landtrackd5qa'] = new undum.SimpleSituation(
	"<p>'I can see right through you.  You're....human.  Tell me. Why did you come here?'</p>\
		<ul class='options'>\
			<li><a href='landtrackd5qb1'>I needed a change.</a></li>\
			<li><a href='landtrackd5qb2'>I felt like exploring.</a></li>\
			<li><a href='landtrackd5qb3'>I'm human?</a></li>\
		</ul>"
		);
		
//Bold
		undum.game.situations['landtrackd5qb1'] = new undum.SimpleSituation(
			"<p>'I needed a change,' said Lin.</p>\
			<p>'You were running away from something. You wanted to change,' <a href='landtrackd5qc3'>said the Queen.</a></p>",
					{
				enter: function (character, system, from) {
					character.qualities.couragearray.push(1);
					var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
					system.setQuality("courage", mostCourage);
				}
			}
	);

//Safe
		undum.game.situations['landtrackd5qb2'] = new undum.SimpleSituation(
			"<p>'I felt like exploring,' said Lin.</p>\
			<p>'You were running away from something.  You wanted to change,' <a href='landtrackd5qc3'>said the Queen.</a></p>",
			{
				enter: function (character, system, from) {
					character.qualities.couragearray.push(2);
					var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
					system.setQuality("courage", mostCourage);
				}
			}
	);

//Timid	

		undum.game.situations['landtrackd5qb3'] = new undum.SimpleSituation(
			"<p>'I human?' offered Lin, tentatively.</p>\
			<p>'You were running away from something.  You wanted to change,' <a href='landtrackd5qc3'>said the Queen.</a></p>",
			{
				enter: function (character, system, from) {
					character.qualities.couragearray.push(3);
					var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
					system.setQuality("courage", mostCourage);
				}
			}
	);




		undum.game.situations['landtrackd5qc'] = new undum.SimpleSituation(
	"<p>'How do you know?' asked Lin, who suddenly felt very exposed.</p>\
	<p>'That's why people go anywhere -- at least if we don't have to - -and we rarely have to. You are unhappy with where you are and think somewhere else you'll change into something else.  Well, you've changed. So are you happy now?'</p>\
	<ul class='options'>\
		<li><a href='landtrackd5qc1'>No.  There's no place like home.></a></li>\
		<li><a href='landtrackd5qc2'>Sure.</a></li>\
		<li><a href='landtrackd5qc3'>I'm not sure.</a></li>\
	</ul>"
	);


	// Bold
	undum.game.situations['landtrackd5qc1'] = new undum.SimpleSituation(
		"<p>'Well, let's see <a href='landtrackd5qd'>if that changes.'</a></p>",
		{
			enter: function (character, system, from) {
				character.qualities.couragearray.push(1);
				var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
				system.setQuality("courage", mostCourage);
			}
		}
);



//Safe
	undum.game.situations['landtrackd5qc2'] = new undum.SimpleSituation(
		"<p>'Well, let's see <a href='landtrackd5qd'>if that changes.'</a></p>",
		{
			enter: function (character, system, from) {
				character.qualities.couragearray.push(2);
				var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
				system.setQuality("courage", mostCourage);
			}
		}
);

//Timid
	undum.game.situations['landtrackd5qc3'] = new undum.SimpleSituation(
			"<p>'Well, let's see <a href='landtrackd5qd'>if that changes.'</a></p>",
			{
				enter: function (character, system, from) {
					character.qualities.couragearray.push(3);
					var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
					system.setQuality("courage", mostCourage);
				}
			}
	);
	
	

	undum.game.situations['landtrackd5qd'] = new undum.SimpleSituation(
	"<p>'You sound like the Trackless people,' says Lin.</p>\
	<p>'We're all trackless,' said the Queen, 'we just have to learn how to get free.' Something about that exchange with the Queen shook Lin, but she had no time to think further on it, for she was soon on her way and the Queen <a href='landtrackdafter'>receding in the background.</a></p>"
	);  



// After school, 

undum.game.situations['landtrackdafter'] = new undum.SimpleSituation(
	"<p>After gliding away from the school, all the children had a choice of one of two tracks for recreation. Whoo-hoo! Finally, a choice. Yes, the citizens of the land down under could either go to the beach or the park.</p>\
		<ul class='options'>\
			<li><a href='landtrackdbeach'>The Beach</a></li>\
			<li><a href='landtrackdpark'>The Park</a></li>\
		</ul>"
);

// The Beach

// If she goes here, she should really see the Pirate ship off the coast -- and the little dingy perhaps. 
undum.game.situations['landtrackdbeach'] = new undum.SimpleSituation(
	"<p>Winding their way along the track, the children who chose the beach found their way toward a great ocean on which she thought she saw -- although it was probably just a mirage -- a pink pirate ship. She began to wonder if this Land Down Under weren't getting to her head. Lin's heart lept a bit as she thought about how much she'd enjoy getting off that track and going for a swim. At least, until she remembered that she was currently made of paper, and that would put a serious crimp, or perhaps sog, <a href='landtrackdbeach1'>in her afternoon.</a></p>"
);

undum.game.situations['landtrackdbeach1'] = new undum.SimpleSituation(
	"<p>Nonetheless, her spirits lifted a bit as she saw the track by the beach that deposited them in lounge chairs for almost ten minutes of cycles. Of course, a beach isn't very much fun when you're just sitting there -- at least, not for Lin who was not fond of places to just cook in the sun waiting for people to look at her -- or not.  She was glad when her chair tipped her back <a href='landtracke'>onto the track.</a></p>"
);


//The Park. 
undum.game.situations['landtrackdpark'] = new undum.SimpleSituation(
	"<p>Everyone loves a park.  Lin herself had always been partial to the swings because it was the closest she figured she'd ever get to flying.  At first glance, this park seemed like any other.  Slides, swings, a jungle gym or two, except that each had a bit of track running through it. A park on a track didn't seem too different.</p>\
	<p>But there was also an offshoot that led out of the park.  Lin remembered something about a path to the meeting after school.</p>\
	<ul class='options'>\
				<li><a href='landtrackdparkoff'>Explore the offshoot.</a></li>\
				<li><a href='landtrackdpark1'>Just hangout in the park.</a></li>\
			</ul>"
);

// The offshoot -- BOLD


undum.game.situations['landtrackdparkoff'] = new undum.SimpleSituation(
	"<p>Enough playing it safe. Lin decided to chance the offshoot.</p>\
	<p>The offshoot at first seemed like it was going to hit a dead end where the track stopped short, but just as Lin was about to hit it, a new track clicked into place and she found herself on a 45 degree angle heading into a waste dump -- a truly chilling place.  For unlike most waste dumps, this did not contain miscellaneous trash -- but crumpled balls of -- I almost cannot say it.  Yes, piled here like so many rejected drafts of a story or failed attempts at a sketch -- the kind you crush and toss into the waste bin like basketballs -- there were mounds of -- Look, it's enough to make this book's flesh crawl -- for you see, it was the very <a href='landtrackdparkoff1'>flesh of books -- Paper.</a></p>",
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(1);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
		}
	}
);

undum.game.situations['landtrackdparkoff1'] = new undum.SimpleSituation(
	"<p>But enough about me.  As Lin progressed through the paper ruins, this graveyard of pulp and acid-free refuse, she was in awe, for it was not just scraps of discarded track, but buildings, and trees, and finally a pit full of what looked like discarded people.  Were they dead paper people? How could paper people die?</p>\
	<ul class='options'>\
		<li><a href='landtrackdparkoff1look'>Look more closely</a></li>\
        <li><a href='landtrackdparkoff1away'>Look away</a></li>\
	</ul>"
	);





// Loook more closely -- BOLD
undum.game.situations['landtrackdparkoff1look'] = new undum.SimpleSituation(
	"<p>She hesitated but on closer inspection, she determined that these paper people were not the dead but rather the discarded. Their demise was not due to some untimely death. Not disease. Not lifespan.  But imperfection.  An uneven cut.  A nose out of place.  One leg shorter than the other.  This was where they collected the slip ups.  <a href='landtrackdparkoff2'>The mistakes.</a></p>",
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(1);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
		}
	}
);

// Look Away -- Timid
undum.game.situations['landtrackdparkoff1away'] = new undum.SimpleSituation(
	"<p>Sometimes when you look away from something you see it anyway -- and see it even larger.  A pit full of paper people.  A pit of crumpled figures piled one on another.  Something had discarded them.  Something had <a href='landtrackdparkoff2'>thrown them away.</a></p>",
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(3);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
		}
	}
);

// Rejoin
undum.game.situations['landtrackdparkoff2'] = new undum.SimpleSituation(
	"<p>'Surprised?' asked a voice coming right beside her. Lin almost lept off her track post. But how could someone be standing beside her? She turned and saw the same girl with the snipped paper from recess, but instead of gliding on the track, she was standing on what looked to be legs folded into feet. </p>\
	<p>'Let me help you,' she said, and offered Lin a hand.</p>\
	<ul class='options'>\
		<li><a href='landtrackdparkoffhelp'>Take the help</a></li>\
        <li><a href='landtrackdparkoffdiy'>Don't take the help -- Do it yourself</a></li>\
        <li><A href='landtrackdparkoffrefuse'>Refuse and leave this place</a></li>\
	</ul>"
	);


// Refuse help sends you back to the track.
	undum.game.situations['landtrackdparkoffrefuse'] = new undum.SimpleSituation(
		"<p>Lin's post took her on a quick lap around what seemed to be a very cool hideout before sending her back to the main track.  As she left, she wished she could turn her head to see a little more. The track led her <a href='landtrackdpark1'>back to the park.</a></p>",
		{
			enter: function (character, system, from) {
				character.qualities.couragearray.push(3);
				var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
				system.setQuality("courage", mostCourage);
			}
		}
);
	// Exits the hide out....  
	
	// Don't take the help
undum.game.situations['landtrackdparkoffdiy'] = new undum.SimpleSituation(
	"<p>With great effort, she managed to scrinch down a tad and spring upward enough to free herrself from the track, but in the process send herrself flat on the ground.</p> \
	<p>'You got some moxie,' said the girl, helping you up and propping her <a href='landtrackdpo1'>against a wall.</a></p>",
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(1);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
		}
	}
);
	
	
	// Take the help. 
undum.game.situations['landtrackdparkoffhelp'] = new undum.SimpleSituation(
	"<p>Lin grasped her hand, and the girl grabbed her by the elbow -- yes, she could move her hand -- lifted Lin off the post, and propped her up <a href='landtrackdpo1'>against a wall.</a></p>",
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(2);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
		}
	}
);

// MORE OF THE HIDEOUT
undum.game.situations['landtrackdpo1'] = new undum.SimpleSituation(
	"<p>Lin's post continued on to a little circle in the corner where it spun as it had done around the bed, which raised the question, would she now fall asleep again? Or based on these fantastic things she was seeing, was she dreaming?</p>\
	<ul class='options'>\
		<li><a href='landtrackdpo1a'>But how can you move your arm?</a></li>\
		<li><a href='landtrackdpo1b'>But how are you standing there?</a></li>\
	</ul>"
	);


//move
	undum.game.situations['landtrackdpo1a'] = new undum.SimpleSituation(
		"<p>'Ah, first you have to get a little snip-snip.'  The girl gestured to two other young women, also snipped and folded, holding some scissors. Lin gasped.</p>\
		<p>'Don't worry. It's cool.  We don't cut off necessary parts.' Lin hadn't begun to speculate on what was necessary or unnecessary about <a href='landtrackdpo2'>her paper body.</a></p>"
	);


undum.game.situations['landtrackdpo1b'] = new undum.SimpleSituation(  
	"<p>Oh, easy.  you split your legs and fold them.</p>\
	<p>'Like when the Little Mermaid gets legs.'</p>\
	<p>'Ha! Never thought of it like that, but sure. Except your tail didn't help you swim kept you stuck <a href='landtrackdpo2'>on that track.'</a></p>"
);

undum.game.situations['landtrackdpo2'] = new undum.SimpleSituation(
	"<p>'Oh, forgot to introduce myself. Safe T. Scissors. Call me Safe. It's my Folder name.'</p>\
	<ul class='options'>\
		<li><a href='landtrackdpo3'>What's going on here?</a></li>\
		<li><a href='landtrackdpo3'>Um, I'm lost.</a></li>\
			</ul>",
			{
				enter: function (character, system, from) {
					character.sandbox.metsafe= true;
				}
			}
);

undum.game.situations['landtrackdpo3'] = new undum.SimpleSituation(
	"<p>'We're Folders. Part of the resistance.</p>\
	<p>'Folders?' asked Lin.</p>\
	<p>Yeah, we can go off track.  And we've figured out ways of walking.</p>\
	<p>'Walking?'</p>\
	<p>'Do you always just repeat whatever someone else says?' Safe teased, making Lin's cheeks flush hot. 'Check this out!' And she took a few strides as though she were a model and then little shimmy and shake that would've made all the track party people's heads turn if they were capable of such a thing.</p>\
	<p>Even though Lin back in the real world was totally mobile. She had so quickly become accustomed to not moving that <a href='landtrackdpo4'>she was in awe.</a></p>"
);	

// Establish about the Queen.
undum.game.situations['landtrackdpo4'] = new undum.SimpleSituation(
	"<p>'We follow our leader, taught us everything we know about folding, snipping, standing on our own two feet!' Lin was dumbstruck at the sight. 'But let me introduce you to the rest of us. That's Exacto Joline.  Billie Shears.  And Hole Punch.'</p>\
	<p>The rather buff one called Hole Punch gave a low, 'Hey.'</p>\
	<p>'She's been lifting weights. Check out how cut she is.' And indeed her arms had been cut into cool looking <a href='landtrackdpo4q'>biceps and triceps.</a></p>"
	);


undum.game.situations['landtrackdpo4q'] = new undum.SimpleSituation(
		"<p>The sight of these Folders was awesome.  Lin had never seen such an awesome band of fighters. No, strike that, Lin had never so much wanted to be part of such an aweseome band of fighters. But she was half afraid that if she let on her thoughts -- how much she'd seen of their battle plans, they'd clam up -- or worse, reject her. What to say?</p>\
		<ul class='options'>\
			<li><a href='landtrackdpo4qbattle'>Looks like you're planning for a battle.</a></li>\
			<li><a href='landtrackdpo4party'>Looks like you're planning for a party.</a></li>\
			</ul>"
	);


// bold
undum.game.situations['landtrackdpo4qbattle'] = new undum.SimpleSituation(
	"<p>She decided to be upfront. 'Looks like you're planning a battle.'</p>\
	<p>'A war,' said Safe.  'A Civil War.  Against the King. And the Ever Trackers.'</p>\
	<p>'Ever Trackers?'</p>\
	<p>'Like the name says, the ones who won't ever leave the track.</p>\
	<p>They're loyal to the King and upset that we're off track.'</p>\
		<ul class='options'>\
			<li><a href='landtrackdpo4battle1'>Why wouldn't you want to be off track?</a></li>\
			<li><a href='landtrackdpo4confident'>You seem pretty confident.</a></li>\
			<li><a href='landtrackdpo4end'>Don't say anything else.</a></li>\
			</ul>"
);

undum.game.situations['landtrackdpo4battle1'] = new undum.SimpleSituation(
	"<p>'Why wouldn't you want to be off track?'</p>\
	<p>'So many questions.  Think about it.  On the track, you got everything you need.  Food.  A place to sleep.  And the most important thing of all...'</p>\
	<p>'A path.  You don't have to make any decisions -- so, no stress because you'll never make the wrong one.  You'll never make ANY one. Except maybe saying the wrong thing.  And even then, it's just WORDS.  It can't change nothing.'</p>\
		<ul class='options'>\
			<li><a href='landtrackdpo4confident'>You seem pretty confident</a></li>\
			<li><a href='landtrackdpo4end'>Don't say anything else.</a></li>\
		</ul>"
	);		

undum.game.situations['landtrackdpo4confident'] = new undum.SimpleSituation(
	"<p>'You seem pretty confident.'</p>\
	<p>'I'm just tough because I ain't afraid of getting hurt no more. I been hurt enough.  Guess you could say that for all of us.'  And the others <a href='landtrackdpo4end'>nodded in agreement.</a></p>"
);


// Party
undum.game.situations['landtrackdpo4party'] = new undum.SimpleSituation(	
	"<p>'Looks like you're planning a party.'</p>\
	<p>'A party?  Did you hear her? I like the way you party.'</p> The others joined in the laugh, making Lin wish she'd just been <a href='landtrackdpo4end'>more up front.</a></p>"
);


undum.game.situations['landtrackdpo4end'] = new undum.SimpleSituation(	
	"<p>'Just wait till you meet the President,' said Safe.</>\
	<p>'You have a queen and a president?'</p>\
	<p>Anna and the others just exchanged smiles, 'So many questions. You'll see... When you're ready.  But for now, we've got to get you back on that track.'</p>\
	<p>And with that, they hoisted her up, placed her back on her pole and gliding her way back to the join part where she fell in line, just in front of Wanda who, if she noticed Lin had been gone, <a href='landtracke'>didn't say a word.</a></p>"
); 






//	This leads away from the meeting -- SAFE

undum.game.situations['landtrackdpark1'] = new undum.SimpleSituation(
	"<p>And as the track moved her through its various structures, bottom of slide to top of monkey bars to one swing on the swings, she realized that there was one thing a park never had and that was a track.  Or to put it another way, a park was a place where one didn't have to go anywhere and could just play. But this, shuttling from one structure to the next, hardly felt like play at all.</p>\
  <p>This felt -- well, not quite like work, and certainly not like school, but like some joyless routine, no more fun than walking up and down the grocery aisles with a foster mom who doesn't even seem to care <a href='landtracke'>that you're there.</a></p>"
);







// THE KING Track e
undum.game.situations['landtracke'] = new undum.SimpleSituation(
	"<h1>A Visit to the King</h1>\
	<p>'Wanda, I've been wondering. If we met the Queen, where's the King?' asked Lin.</p>\
			<p>You'll see him next. He's under water,' said Wanda.</p>\
			<p>'Under water?' Lin could think of nothing worse for paper than to get wet.  Surely that would be the end of her.  She'd get limp and then start to tear like toilet paper.  Oh, this was a sad <a href='landtracke1'>way to go.</a></p>"
);

undum.game.situations['landtracke1'] = new undum.SimpleSituation(
	"<p>What she didn't notice was that she was gliding over to a kind of loading area.  There, all of the children from the school were now standing in orderly lines in front of another large conveyor belt system. One by one they were whisked down a small ramp and <a href='landtracke2'>out of sight.</a></p>"
);

undum.game.situations['landtracke2'] = new undum.SimpleSituation(
	"<p>When it was Lin's turn, she heard a final, 'Don't worry,' from Wanda, before she was pulled forward and then down a ramp.  Once on a small platform, she was raised up even higher than the track by some sort of mechanical arm.  Another arm lowered down to her side and before she knew it, she was being spun around and wrapped in plastic wrap.  By the end, she was wrapped head to toe like a laminated card or a wedge of cheese sealed air tight <a href='landtrackee3'>for freshness.</a></p>"
);

undum.game.situations['landtrackee3'] = new undum.SimpleSituation(
	"<p>She was ejected back onto the track.</p>\
		 <p>'Stop that,' said Wanda from behind her.</p>\
	     <p>And it was then that she realized that she'd been screaming the entire time.</p>\
	     <p>'The wrap protects us for when we go underwater.  <a href='landtracke4'>You'll see.'</a></p>"
);

undum.game.situations['landtracke4'] = new undum.SimpleSituation(
	"<p>And within moments she did see as the track whisked her down beneath the surface of what appeared to be <a href='landtracke5'>a great ocean.</a></p>"
);



undum.game.situations['landtracke5'] = new undum.SimpleSituation(
	"<p>Out of the corners of her eyes, Lin noticed the glimmering of silver.  The gilmmers seemed to be growing nearer, a whole cluster of them like bright shiny coins.</p>\
		 <p>'Don't get too nervous about the piranhas.'</p>\
		 <p>'Piran--'</p>\
		 <p>And before she knew it, Lin was screaming again at the top of her lungs, as a large school of piranhas reached her and began to swarm all about her.  Even without turning her head she could see the razor-like teeth and the cold unblinking eyes.  </p>\
		 <p>'Calm down,' said Wanda, 'They can't bite you.  They can't even move their jaws. They're like us.'</p>\
		 <p>And just then, one of them turned sideways, and she could see that just like them, the fish were two-dimensional with fixed jaws, and they were dangling from strings, like fishing line.</p>\
		 <p>'See, nothing to worry about.'</p>\
		 <p>Somehow Lin did worry a bit about the piranhas with their fierce pointed teeth even if they were <a href='landtracke6'>two dimensional.</a> </p>"
);

undum.game.situations['landtracke6'] = new undum.SimpleSituation(
	"<p>Underwater had an entirely different look than the above world.  Where that world was full of bright cities and cozy villages, this landscape of the ocean world had more of a fantastical flare.  Treasure boxes and reptile bones hid behind seaweed <a href='landtracke7'>and sea stars.</a></p>"
);

undum.game.situations['landtracke7'] = new undum.SimpleSituation(
	"<p>On a clear plane of pebbles, Lin spotted a huge castle that looked like the larger version of the kind you might find in a fish tank.  Except this one, she soon learned, had an inside, as the track slid her in through the main gate and into <a href='landtracke8'>a great hall.</a></p>"
);

undum.game.situations['landtracke8'] = new undum.SimpleSituation(
	"<p>'What happens here?' asked Lin, but her question was soon answered as they continued to glide in their glistening plastic wrap to what appeared to be a great snake, ten time larger than they were, and when it opened its mouth, massive crescent-shaped <a href='landtracke9'>fangs emerged.</a></p>"
);

undum.game.situations['landtracke9'] = new undum.SimpleSituation(
	"<p'What's that?' asked Lin.</p>\
	 <p>'That's the King, the basilisk King of the Land Down Under, Ruler of the Paper empire and undersea realms,' replied Wanda who seemed equally terrified. 'And please <a href='landtracke9a'>stop screaming.</a>'</p>"
);

undum.game.situations['landtracke9a'] = new undum.SimpleSituation(
	"<p>Lin caught herself again. She'd have to stop doing that especially since none of the other people seemed terribly frightened.  In fact, they seemed rather happy, as the scene in the King's great hall took on the look of the scene outside the school where the Queen of Hearts was greeting all of the students.  The flat citizens of the Land Down Under glided past the King who looked on each of <a href='landtracke9b'>them and smiled.</a></p>"
);

undum.game.situations['landtracke9b'] = new undum.SimpleSituation(
	"<p>The King sat upon a throne made entirely of jewels and was flanked on either side by a large, imposing mushroom with arms and legs.</p>\
		 <p>'What's up with the shrooms?' asked Lin.</p>\
		 <p>'His guards, of course.  The Broadcoo may look like fungus, but they're not exactly <em>fun guys</em>.'</p>\
		 <p>Lin tried not to wince at that last joke -- which to be honest, I just inserted.  She didn't say that at all. <a href='landtracke9c'>Apologies.</a></p>\
		 <center><img src='media/games/tutorial/images/landdown3_440.png' alt='The subjects glide past the kind and his mushroom guards'></center>"
);


undum.game.situations['landtracke9c'] = new undum.SimpleSituation(
	"<p>'The King's not happy,' said Lin more to herself.  'That snake is not happy.'</p>\
		 <p>'He's the one who put us all on this track. He's not a snake.  He's a Basilisk,' said the boy in front of Lin.</p>\
		 <p>'What's the difference?' <a href='landtracke9d'>asked Lin.</a></p>"
);

// Part Snake, part

undum.game.situations['landtracke9d'] = new undum.SimpleSituation(
	"<p>The closer Lin got to the King, the less she could believe that he was happy.  Though his mouth did stretch in what appeared to be a smile, in his eyes glowed an ice cold gaze that spoke of a hatred for <a href='landtracke9e'>all his subjects.</a></p>"
);

undum.game.situations['landtracke9e'] = new undum.SimpleSituation(
	"<p>When Lin and Wanda were finally presented, the King moved forward in a way he had not <a href='landtracke9f'>for the others.</a.</p>"
);

undum.game.situations['landtracke9f'] = new undum.SimpleSituation(
	"<p>'Welcome to my castle.'</p>\
		 <p>'We live to serve you. We are your humble subjects,' Wanda said as the others had and Lin tried to mumble along as one might to a song whose words they do not entirely know.</p>\
		 <p>'Thank you,' he hissed. 'I hope you will enjoy your stay,'</p>\
		 <p>And they were whisked off again, this time around one of the large statues that stood at the base <a href='landtracke9g'>of his throne.</a></p>"
);


undum.game.situations['landtracke9g'] = new undum.SimpleSituation(
	"<p>'What was that all about?' asked Wanda.</p>\
		<p>'What do you mean?'</p>\
		<p>'He never says that,' said Wanda, whose voice had <a href='landtracke9h'>begun to waver.</a></p>"
);


undum.game.situations['landtracke9h'] = new undum.SimpleSituation(
	"<p>But before they could continue talking, they found themselves staring up at one of the giant statues.  It was a turtle but also appeared to be a samurai, as it held in its hand a massive sword, and the look on its face was struck with <a href='landtracke9i'>deadly calm.</a></p>"
);

undum.game.situations['landtracke9i'] = new undum.SimpleSituation(
	"<p>Behind the statues was a curtained off area which none of the tracks intersected.  Needless to say, this made Lin more than a little curious because, well, what's a curtain for if not to <a href='landtracke9j'>hide something.</a></p>"
);

undum.game.situations['landtracke9j'] = new undum.SimpleSituation(
	"<p>Lin had to know what was behind the curtain. It's just a thing.  Being trapped on a track was too much. Leaning over to look behind the curtain, Lin accidentally <a href='landtracke9k'>bumped into the guard. </a></p>"
);

undum.game.situations['landtracke9k'] = new undum.SimpleSituation(
	"<p>Now,you might not think a little girl bumping into a great stone statue would have any effect. Except this statue was not in fact made out of stone but instead... balloons.  So, knocking into it had the effect of setting it free to float to the top of the castle through the hole and up into the water, leaving behind some hidden track.   No sooner had Lin noticed the statue's departure that she also noticed that she was sliding toward the <a href='landtracke9l'>hidden track.</a></p>"
);


undum.game.situations['landtracke9l'] = new undum.SimpleSituation(
	"<p>Lin went under the curtain and said, 'Waaah' as they do when they dance the Nae Nae.</p>\
		<p>The track led straight through the curtain and into a darkened area in the center of which stood a large panel with a solitary switch.  Above the switch was a sign with the simple stenciled warning, 'Danger, do not touch.' Lin did not know exactly what that switch did, but she felt deep in her paper heart that the switch was the source of this King's power <a href='landtracke9m'>over the people.</a></p>"
);


undum.game.situations['landtracke9m'] = new undum.SimpleSituation(
	"<ul class='options'>\
		<li><a href='landofftracka'>Flip the switch?</a></li>\
		<li><a href='landtrackf'>Leave the switch alone.</a></li>\
		</ul>"
);

/* Switch:
Flip the Switch?
Don't  */


// Did not Flip
undum.game.situations['landtrackf'] = new undum.SimpleSituation(
	"<p>Lin decided not to flip the switch.</p>\
		<p>Yep.</p>\
		<p>She did not flip <a href='landtrackf1'>the switch.</a></p>",
		{
			enter: function (character, system, from) {
				character.qualities.couragearray.push(3);
				var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
				system.setQuality("courage", mostCourage);
				system.write("<p><em>That choice might be beyond timid -- to downright chicken.</em></p>")
			}
		}
	);



// Did not Flip
undum.game.situations['landtrackf1'] = new undum.SimpleSituation(
	"<p>Instead she and Wanda were whisked around the curtained area until they reached a steep track on the other side </p>\
		<p>'Oh, well,' said Wanda.</p>\
		<p>'What's happening?' asked Lin, but before Wanda could answer they had risen on the angled track all the way above water again, where the machines dutifully unwrapped them and placed them back on the track.</p>\
		<p>'But where will we go now?' <a href='landtrackf2'>asked Lin.</a></p>"
);

undum.game.situations['landtrackf2'] = new undum.SimpleSituation(
	"<p>'You'll see,' responded Wanda as they rounded a great bend in the track.  It was there that Lin saw piles of flat papers people, lying in great disorganized heaps.</p>\
		<p>'What happened to them?' asked Wanda.</p>\
		<p>'Why, Lin, you know,' replied Wanda without much sympathy.  'They slipped off the track and had no way to get anywhere.'</p>\
		<p>'Why not'?</p>\
		<p>'You've seen our legs and feet, haven't you? Not so good for mobility. </p>\
		<p>And indeed, Wanda was <a href='landtrackf3'>right again.</a></p>"
);


undum.game.situations['landtrackf3'] = new undum.SimpleSituation(
	"<p>It became clear where they were headed.  Back to the beginning of the track.</p>\
		<p>'The track is just one big loop?' asked Lin.</p>\
		<p>'Worse than that,' said Wanda.  'The Loop never changes.'</p>\
		<p>Lin had many questions but one large lump of dread, which grew as the meaning of what Wanda had said hit her. Every. Loop. Exactly. The. Same.  And they were <a href='landtrackfjet'>about to restart.</a></p>"
);


undum.game.situations['landtrackfjet'] = new undum.SimpleSituation(
	"",
	{
		enter: function (character, system, from) {
			system.write("<p>Let me be clear, they were about to restart the whole cycle through the Land Down Under, exactly as I told it to you the last time, starting when Lin first first found her way onto the track.</p>");
			if (character.qualities.jetpack >= 2) {
				character.sandbox.whereto = from;
				system.write("<br/><em><p class='transient'>Uh, oh, don't want to go back to the beginning?  You could use a jetpack and make a different choice.</em></p>");
				system.write("<p class='transient'><ul class='options'>\
			<li><a href='./jetpackgo' class='once' onClick='_gaq.push([\"_trackEvent\",  \"Spyeye\", \"Jetpack\", \"used\"]);'>Use Jetpack?</a></li>\
			<li><a href='landdownentera'>Don't</a></li></ul></p>");
			}
			else {
				system.write("<p>And since you have no more jetpacks, I guess you'll just have to click your way through it. <a href='landdownentera'>Bon voyage!</a></p>");
			}
		},
		actions: {
			'jetpackgo': function (character, system, action) {
				system.setQuality("jetpack", character.qualities.jetpack - 2);
				system.write("<p class='transient'>When the big dial is turned to 'Launch,' the jetpacks rumble to life, spewing white steam of smoke and rattling like a snoring pig. Lin and Wanda managed to get it on like a backpack BEFORE pressing 'GO.'</p>\
				 <p class='transient'>3-2-1</p>\
				 <p class='transient'>The jetpacks rocketed Lin and Wanda zipping over the track.  Eventually, they are above the smog and in a clear blue sky.</p>\
				 <p class='transient'>A message on the strap flashes: Approaching Jump</p>\
				 <p class='transient'>What could this mean? Jump where? Well, only <a href='landtracke9m'>one way to find out!</a></p>");
			}
		}
	}
);



// Set a counter here for each time through   


// Did Flip
undum.game.situations['landofftracka'] = new undum.SimpleSituation(
	"<p>Lin decided to flip the switch, but not having movable arms made that rather challenging. However, she calculated that if she were to increase her speed a bit she might be able to use the force of her body <a href='landofftracka1'>to flip it.</a></p>",
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(1);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
			system.write("<p><em>That's about as bold as you can get!</em></p>")
		}
	}
);



// Fix This. (Not sure how it's broken)


undum.game.situations['landofftracka1'] = new undum.SimpleSituation(
	"<p>And now she was gliding toward the switch at a more rapid speed than she anticipated.  What made this track speed up, and what would happen if it did not slow?  She'd be thrown up against the wall,<a href='landofftracka2'> she calculated.</a></p>"
);


undum.game.situations['landofftracka2'] = new undum.SimpleSituation(
	"<p>Just as she reached the end of the track, she was thrown forward straight at the wall.  Good thing she was already flat or that wall would've made a pancake of her.  But then she noticed something else. Having been thrown from the track onto the wall, she'd also been thrown into the switch and had flipped it <a href='landofftracka3'>with her body.</a></p>"
);


undum.game.situations['landofftracka3'] = new undum.SimpleSituation(
	"<p>The lights buzzed and flickered and everywhere across the water could be heard a great <a href='landofftracka4'>series of pops.</a></p>"
);

undum.game.situations['landofftracka4'] = new undum.SimpleSituation(
	"<p>Looking behind her, Lin could not believe her eyes as she took in the sight of the people from the Land Down Under, freed from their track and floating upward.  Lin was floating upward too and managed to slide through a crack in an open window, up and out of the castle, to rise with hundreds or was it thousands of two-dimensional people up toward the surface <a href='landofftracka5'>of the water.</a></p>"
);

undum.game.situations['landofftracka5'] = new undum.SimpleSituation(
	"<p>Above water, she managed to kick toward land, since her legs were now no longer joined together and the land was not actually all that far off.  They had gone further <a href='landofftrackb'>down than out.</a></p>",
	{
		enter: function (character, system, from) {
			system.setQuality("distance", "3/5");
			system.animateQuality("complete", character.qualities.complete + 20);
		}
	}
);





// Beach with Wanda

undum.game.situations['landofftrackb'] = new undum.SimpleSituation(
	"<p>Soon she found herself lying flat on the edge of a  beach, unwrapped  <a href='landofftrackb1'>and exhausted.</a></p>"
);


undum.game.situations['landofftrackb1'] = new undum.SimpleSituation(
	"<p>All along the beach, flat bodies stretched out.  Some were still kicking through the water, and then Lin saw something incredible as a swimmer rose to her feet, having folded her base into shoes.  But <a href='landofftrackb2'>that must mean --></a></p>"
);


undum.game.situations['landofftrackb2'] = new undum.SimpleSituation(
	"<p>And yes it did! Not only were their legs free, but they could move their arms, their hands, their necks, and even their mouths.  Lin blinked for the first time in hours.  She could even move her fingers, though they were attached to one another.  She'd have to cut them apart.  But she could move her body parts, and so could everyone else.  This was <a href='landofftrackb3'>incredible!</a></p>"
);


undum.game.situations['landofftrackb3'] = new undum.SimpleSituation(
	"<p>But soon it became apparent that not everyone could fold their feet. Well, it's not that they couldn't. They just didn't seem to know how.  They just laid there on the shore, kicking their legs, panting from exhaust, flailing about a <a href='landofftrackb4'>bit like fish.</a></p>"
);


undum.game.situations['landofftrackb4'] = new undum.SimpleSituation(
	"<p>A murmur grew among those who had the feet folding technique. 'Who flipped the switch? <a href='landofftrackb5'>Where? How?'</a></p>"
);

// People can choose how to answer: Admit or don't 

//If you do

undum.game.situations['landofftrackb5'] = new undum.SimpleSituation(
	"<p>Quietly at first and then louder, Lin said, 'Me. <a href='landofftrackb6'>It was me.'</a></p>"
);

undum.game.situations['landofftrackb6'] = new undum.SimpleSituation(
	"<p>And soon all eyes were on her.</p>\
			<p>'You? You? We've been trying to get to that switch in forever, but we were always too scared to confront <a href='landofftrackb7'>the guards.'</a></p>"
);

undum.game.situations['landofftrackb7'] = new undum.SimpleSituation(
	"<p>'That's silly,' said Lin. </p>\
	<p>They gasped. </p>\
	<p>'I mean, they were made out of balloons.' </p>\
	<p>They gasped while they were gasping making a kind of ahhhh-huh---ah---huhh sound. </p>\
	<p>'You're not safe here. We've got to get you to Folders home base. Come with us!' said a woman, whose left the beach on feet folded into kick-butt boots.</p>\
	<p>But before she could follow them, something else caught her eye -- or was <a href='landofftrackb8'>it her ear?</a></p>"
);






undum.game.situations['landofftrackb8'] = new undum.SimpleSituation(
	"<p>One of the paper women, wriggling on the sand, was roaring at all the walkers.</p>\
	<p>'How are you walking?  Get me up on my feet! Don't just leave me here!'</p>\
	<p>As Lin approached, the woman, or girl really, managed to roll slightly to face her. Lin, or course, knew who it was.</p>\
			<p><a href='landofftrackb8a'>'Hey, Wanda.'</a></p>"
);



// Help Wanda up
// Leave her there

undum.game.situations['landofftrackb8a'] = new undum.SimpleSituation(
	"<p>'Lin, Linsy, you've been holding out on me. How did you get up on those feet? You gotta help me.'</p>\
	<p>Linsy? Wanda hadn't used that name in a long time -- not since back in the house when she'd wanted something from Lin. Still, Lin couldn't take the sight of her flopping around on the sand. She bent down and folded Wanda's feet for her.  AS Wanda rose unsteadily, Lin could already see a smile spreading across her face, a smile of superiority to those who were not up.  It made Lin <a href='landofftrackb8b'>a little sick.</a></p>"
);

undum.game.situations['landofftrackb8b'] = new undum.SimpleSituation(
	"<p>'Oh, Lin, I'm so glad to see you.  I thought we'd never find each other again,'  She gave Lin a hug, and Lin was touched by the feeling of her thin paper arms, which embraced but without tenderness and soon she pushed her away.</p>\
	<p>'Have you found Peter yet? We've got to find him! Now that we're off that track, maybe we can.  Will you help me, Lin?' Wanda accosted her.</p>\
	<p>Lin wasn't sure which question she should be answering.  'I don't know,' Lin shrugged. 'I think the Folders could use my help.'</p>\
	<p>'Well, we can't go <a href='landofftrackb8b1'>back without him.'</a></p>"
);


	undum.game.situations['landofftrackb8b1'] = new undum.SimpleSituation(	
	"<p>'I understand, but what do you expect me to do?'</p>\
	<p>'Find him!'</a></p>\
	<ul class='options'>\
			<li><a href='landofftrackd'>Go find Pete</a></li>\
			<li><a href='landofftrackc'>Go find the Folders first, then find Pete</a></li>\
			<li><a href='landofftracke1'>No time to worry about Pete, find a boat out of here!</a></li>\
			</ul>",
	{
		enter: function (character, system, from) {
			system.setQuality("distance", "4/5");
			system.animateQuality("complete", character.qualities.complete + 20);
		}
	}
);




// The Folders Preparation Club house
//If she was a balloon and talked with Timmy, he'll show up here...

undum.game.situations['landofftrackc'] = new undum.SimpleSituation(
	"",
	{
		enter: function (character, system, from) {
			if (character.sandbox.metsafe == true){
		system.write("<p>Lin led Wand to the hideout and enjoyed watching her show the same amazement Lin had when she'd first visited it. Inside the darkened room decorated with every manner of paper streamers, they found the rest of the Folders. And there, seated crosslegged in the middle was the Queen.</p>\
			<p>Now it was Lin's turn to gasp.</p>\
			<p>'Queen of Hearts --'</p>\
			<p>'Call me Lucy -- and here I'm the President, not the Queen.  An elected official. It's different.'</p>\
			<p>The Queen looked the same as before, yet somehow different. Was it how the light was hitting her? No. It was the folds. She was folded slightly differently which gave, what was the word? Dimension. Yeah. Sides to her that Lin hadn't noticed before.</p>\
			<p>'What are you doing here?' <a href='landofftrackc1'>asked Lin.</a></p>");
			}
			else {
				system.write("<p>Fortunately, Lin remembered something Anna had said about getting to the hideout through the park, so she led Wanda that way. Inside a darkened room decorated with every manner of paper streamers, they found the rest of the Folders. And there, seated crosslegged in the middle was the Queen.</p>\
				<p>Now it was Lin's turn to gasp.</p>\
				<p>'Queen of Hearts --'</p>\
				<p>'Call me Lucy -- and here I'm the President, not the Queen.  An elected official. It's different.'</p>\
				<p>The Queen looked the same as before, yet somehow different. Was it how the light was hitting her? No. It was the folds. She was folded slightly differently which gave, what was the word? Dimension. Yeah. Sides to her that Lin hadn't noticed before.</p>\
				<p>'What are you doing here?' <a href='landofftrackc1'>asked Lin.</a></p>");
			}
		}
	}

);




undum.game.situations['landofftrackc1'] = new undum.SimpleSituation(
	"<p>The President replied in more of a teacherly voice, 'This is a folding gathering.  Anyone who knows how folds anything they make three dimensionally to help people on the streets who don't have three dimensions.'</p>\
			<p>'Like what? What could we make that could help them.'</p>\
			<p>'Well, we can fold up shoes that we can slip their feet into, so we don't have to fold everyones feet up like ours.'</p>\
			<p>Lin was amazed at the grace of the Queen, how easily she expressed her concern for others, and how naturally she came <a href='landofftrackc2'>to this work.</a></p>"
);

undum.game.situations['landofftrackc2'] = new undum.SimpleSituation(
	"<p>But things didn't quite add up and so in the midst of their folding, Lin blurted out, 'But what about the King?'</p>\
			<p>Silence engulfed the room.</p>\
			<p>Without looking up, the Queen replied, simply, 'He can't move on.  He'll be stuck, stuck in the past, on his track.'</p>\
			<p>'But he's free, just like the rest of us.'</p>\
			<p>The President replied, 'But that's just it.  He was never free. That's why he had to stick everyone else <a href='landofftrackc3'>on the track.'</a></p>"
);


undum.game.situations['landofftrackc3'] = new undum.SimpleSituation(
	"<p>The more Lin watched the Queen work, or the President really, the more she admired her.  The President had this humble grace to the way she went about her folding and, important as she was, didn't seem to need to put on airs or call any attention to herself or to her work. It was as if the folding were enough, folding for others.  And then Lin recognized something else.  It was time for <a href='landofftrackc4'>her to go.</a></p>"
);


undum.game.situations['landofftrackc4'] = new undum.SimpleSituation(
	"<p>As if reading her thoughts, the President declared, 'As much as our friend would like to stay, I'm afraid she must be <a href='landofftrackc5'>on her way.'</a></p>"
);


undum.game.situations['landofftrackc5'] = new undum.SimpleSituation(
	"<p>There's something about that moment when someone else speaks what you so dearly believe in your heart -- but don't yet want to face.  A kind of coldness comes over you that robs you of all of your illusions, all of your desire to pull up the covers over your head and hide from the day.  This is the feeling of recognizing your destiny.  This is the feeling of growing up.  But you already knew that, <a href='landofftrackc6'>didn't you?</a></p>"
);


undum.game.situations['landofftrackc6'] = new undum.SimpleSituation(
	"<p>And so, Lin rose, grabbed a few of the folded shoes and giving the Queen a long, tender hug, nodded to Anna, and left the gathering.</p>\
		<p>'What now?' asked Wanda.</p>\
		<ul class='options'>\
			<li><a href='landofftrackd'>Go find Pete</a></li>\
			<li><a href='landofftrackc6a'>No time for Pete. Go back to the beach and split.</a></li>\
			</ul>"
);


undum.game.situations['landofftrackc6a'] = new undum.SimpleSituation(
	"<p>That decision gave Lin pause, almost more than it did Wanda. Leaving without Pete. It sounded so final.</p>",
	{
		enter: function (character, system, from) {
			character.qualities.couragearray.push(3);
			var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
			system.setQuality("courage", mostCourage);
			if (character.qualities.jetpack >= 2) {
				character.sandbox.whereto = from;
				system.write("<br/><em><p class='transient'>But do you <em>really</em> want to leave Pete down here?  Surely you could try once more.</p>");
				system.write("<p class='transient'><ul class='options'>\
			<li><a href='./jetpackgo' class='once' onClick='_gaq.push([\"_trackEvent\",  \"Spyeye\", \"Jetpack\", \"used\"]);'>Use Jetpack?</a></li>\
			<li><a href='landofftracke'>Don't</a></li></ul></p>");
			}
			else {
				system.write("<p>It hurt Lin and Wanda to leave Pete down here, but he had left long ago.  And no doubt Mrs. Wobbles could help <a href='landofftracke'>get him out later.</p>");
			}
		},
		actions: {
			'jetpackgo': function (character, system, action) {
				system.setQuality("jetpack", character.qualities.jetpack - 2);
				system.write("<p class='transient'>When the big dial is turned to 'Launch,' the jetpacks rumble to life, spewing white steam of smoke and rattling like a snoring pig. Lin and Wanda managed to get it on like a backpack BEFORE pressing 'GO.'</p>\
				 <p class='transient'>3-2-1</p>\
				 <p class='transient'>The jetpacks rocketed Lin and Wanda zipping over the track.  Eventually, they are above the smog and in a clear blue sky.</p>\
				 <p class='transient'>A message on the strap flashes: Approaching Jump</p>\
				 <p class='transient'>What could this mean? Jump where? Well, only <a href='landofftrackc6'>one way to find out!</a></p>");
			}
		}
	}
);





// Peter's Lair 		

undum.game.situations['landofftrackd'] = new undum.SimpleSituation(
	"<h1>Pete's Lair</h1>\
		<p>The room did not look very promising.  I mean, as a room, there was not a lot of promise in it or for anyone who inhabited it.  It was a room of low ambition.  A fog of noise, the din of video game sound effects, and smell, unwashed socks and soggy paper and armpits, seemed to hang over the room. Desolate.  Full of video games and half-drunk soda pop cans, empty chip bags, <a href='landofftrackd1'>laziness, drowsiness.</a></p>"
);


undum.game.situations['landofftrackd1'] = new undum.SimpleSituation(
	"<p>There, around a game console, sat its current occupants, three boys and a girl, all flattened out on the couch, turned just enough to see the <a href='landofftrackd2'>TV screen.</a></p>"
);


undum.game.situations['landofftrackd2'] = new undum.SimpleSituation(
	"<p>'Oh my goodness,' exclaimed Wanda.  'What is this?' And her face squinched like a scrunchie with her lips curled and eyebrows drawn  into one big Ewww.</p>\
			<p>Lin looked at the faces of the boys. Their eyes seemed glazed and did not look away when she peered into them.  When Lin coughed loudly, the last of these boys pulled his eyes free from the TV long enough to look at her.</p>\
			<p><a href='landofftrackd3'>'Lin?'</a></p>"
);


undum.game.situations['landofftrackd3'] = new undum.SimpleSituation(
	"<p>She nodded.</p>\
		 <p>But Wanda pushed her aside and would have toppled her over if it weren't for the wall, shouting, 'Peter! Peter! How did you end up here?' And if he hadn't been flat before, he would've been after the hug that she gave him.  Although he did not have origami shoes, she lifted him off the couch, dangling his <a href='landofftrackd4'>legs and arms.</a></p>"
);


undum.game.situations['landofftrackd4'] = new undum.SimpleSituation(
	"<p>'We've got to go.'</p>\
			<p>But Peter did not answer.  He just let himself dangle there as his head lolled to the side so he could still <a href='landofftrackd5'>see the TV.</a></p>"
);



undum.game.situations['landofftrackd5'] = new undum.SimpleSituation(
	"<p>What's wrong with him?' asked Wanda, shaking him like a rag doll.</p>\
			<p> Lin shook her head.  From the looks of the other kids hanging out on the couch, they were not totally awake, they had not even realized the freedom they had now, that they were free <a href='landofftrackd6'>from the track.</a></p>"
);




undum.game.situations['landofftrackd6'] = new undum.SimpleSituation(
	"<p>'How long have you been here?' asked Wanda.</p>\
			<p>Gradually, slowly, the girl turned her head to face them, her eyes still on the TV, and she said, 'It's been hours.' And then after a pause like thinking.  'It's been days.' And after one more long pause. 'I think...' and she trailed off.</p>\
			<p>'How did you get here?' asked Lin, but now she could see it.  The room was located in a little alcove beneath a bend in the track.</p>\
			<p>'You fell off,' she said, looking back toward the girl.  'You all fell off up there?'</p>\
			<p>The girl gave a nod, barely perceptible, but a nod <a href='landofftrackd7'>just the same.</a></p>"
);



undum.game.situations['landofftrackd7'] = new undum.SimpleSituation(
	"<p>'We've got to get OUT of here!' said Wanda, her face still pinched.</p>\
			<p>'But,' and now Peter spoke again, still in the mumble, 'I don't want to go. None of us want to go. We're here cause we're here and we're just here cause we're here.'</p>\
			<p>Wanda could not control her rage, but shook him now more violently, 'What is wrong with you?'</p>\
			<p>'I'm flat,' he replied.</p>\
			<p>And with his words came a kind of chill, laden with a kind of giving up, a sense of despair.</p>\
			<p>'I know you are. We all are! We all are,' and now Wanda was crying, 'We've been this way ever since we came down here, but can't you see? We're free to go.  We're not on the track anymore.'</p>\
			<p>But the words fell to the floor without Peter even seeming to notice them as he had drifted back into the sleep of the rest of the children in the room, lulled by the hum of the television screen and the <a href='landofftrackd8'>video game console.</a></p>"
);



undum.game.situations['landofftrackd7'] = new undum.SimpleSituation(
	"<p>What are we going to do?</p>\
				<ul class='options'>\
					<li><a href='landofftrackd8'>Leave him here.</a></li>\
					<li><a href='landofftrackd8a'>Try to get him home</a></li>\
					</ul>"
);



// Leave Pete behind

undum.game.situations['landofftrackd8'] = new undum.SimpleSituation(
	"<p>We have to go, Wanda,' said Lin.</p>",
	{
		enter: function (character, system, from) {
			if (character.qualities.jetpack >= 2) {
				character.sandbox.whereto = from;
				system.write("<br/><em><p class='transient'>But do you <em>really</em> want to leave Pete down here?</p>");
				system.write("<p class='transient'><ul class='options'>\
			<li><a href='./jetpackgo' class='once' onClick='_gaq.push([\"_trackEvent\",  \"Spyeye\", \"Jetpack\", \"used\"]);'>Use Jetpack?</a></li>\
			<li><a href='landofftrackd8leave'>Don't</a></li></ul></p>");
			}
			else {
				system.write("<p>It hurt Wanda to leave Pete down here, but she had lost him a long time ago.  And no doubt Mrs. Wobbles could help <a href='landofftrackd8leave'>get him out later.</p>");
					character.qualities.couragearray.push(3);
					var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
					system.setQuality("courage", mostCourage);
			}
		},
		actions: {
			'jetpackgo': function (character, system, action) {
				system.setQuality("jetpack", character.qualities.jetpack - 2);
				system.write("<p class='transient'>When the big dial is turned to 'Launch,' the jetpacks rumble to life, spewing white steam of smoke and rattling like a snoring pig. Lin and Wanda managed to get it on like a backpack BEFORE pressing 'GO.'</p>\
				 <p class='transient'>3-2-1</p>\
				 <p class='transient'>The jetpacks rocketed Lin and Wanda zipping over the track.  Eventually, they are above the smog and in a clear blue sky.</p>\
				 <p class='transient'>A message on the strap flashes: Approaching Jump</p>\
				 <p class='transient'>What could this mean? Jump where? Well, only <a href='landofftrackd7'>one way to find out!</a></p>");
			}
		}
	}
);





undum.game.situations['landofftrackd8leave'] = new undum.SimpleSituation(
	"<p>There was nothing they could do -- or that's what they decided.  Peter was wrapped in the fog of the television and the haze of chips, lying on the couch with his flat friends.  You can do a lot for people, but not everything.  Or how did Mrs. Wobbles put it?  You can wash a person's underwear, but you can't make them change into it.  (She was referring to Jarod, but he's in a different story).</p>\
		<p><a href='landofftracke'>So they left.</a></p>"
);


// Do Something
// Do something with his shlocks?

//Carry Him

undum.game.situations['landofftrackd8a'] = new undum.SimpleSituation(
	"<p>Fortunately, Peter was paper thin, so he wasn't that heavy.  Unfortunately, Peter had been drinking soda and eating chips and pizza for the past few weeks, so he was a bit heavier than you might expect.  Oh, and Lin and Wanda were also made of paper, so they weren't <a href='landofftrackd8b'>particularly strong.</a></p>"
);



undum.game.situations['landofftrackd8b'] = new undum.SimpleSituation(
	"<p>With quite a bit of effort, the two were able to get him up off the couch.  But now, how could they possibly get him moving? Dividing his weight, one could push and the other pull, but still he'd have to at least move his feet to walk.</p>\
		<ul class='options'>\
		<li><a href='landofftrackdpullpete'>Pull him</a></li>\
		<li><a href='landofftrackpushpete'>Push him</a></li>\
		</ul>"
);


/*	Peter's been bossed around a lot, so he has no opinions.  Was severely mocked for his drooling.  Pulling him does not help.  But if you push him and let him steer that works.
*/


//Pull him	
undum.game.situations['landofftrackdpullpete'] = new undum.SimpleSituation(
	"<p>Pete just stared at Lin and fell back with all his weight.  She got the feeling he didn't like being dragged around.</p>\
	    <p>Try pushing him or give up?</p>\
	    <ul class='options'>\
	        <li><a href='landofftrackpushpete'>Try pushing him</a></li>\
	        <li><a href='landofftrackd8c'>Give up and go to the beach</a></li>\
	        </ul>"
);


// Give up and head to the beach

undum.game.situations['landofftrackd8c'] = new undum.SimpleSituation(
	"<p>Enough was enough.  If Pete didn't want to go, they weren't going to make him.</p>\
	    <p>It was time to head to the beach.</a></p>",
	{
		enter: function (character, system, from) {
			if (character.qualities.jetpack >= 2) {
				character.sandbox.whereto = from;
				system.write("<br/><em><p class='transient'>But do you <em>really</em> want to leave Pete down here?  Surely you could try once more.</p>");
				system.write("<p class='transient'><ul class='options'>\
			<li><a href='./jetpackgo' class='once' onClick='_gaq.push([\"_trackEvent\",  \"Spyeye\", \"Jetpack\", \"used\"]);'>Use Jetpack?</a></li>\
			<li><a href='landofftracke'>Don't</a></li></ul></p>");
			}
			else {
				system.write("<p>It hurt Wanda to leave Pete down here, but she had lost him a long time ago.  And no doubt Mrs. Wobbles could help <a href='landofftracke'>get him out later.</p>");
						character.qualities.couragearray.push(2);
						var mostCourage=undum.MaxDecision(character.qualities.couragearray, character.qualities.couragearray, 5);
						system.setQuality("courage", mostCourage);
			}
		},
		actions: {
			'jetpackgo': function (character, system, action) {
				system.setQuality("jetpack", character.qualities.jetpack - 2);
				system.write("<p class='transient'>When the big dial is turned to 'Launch,' the jetpacks rumble to life, spewing white steam of smoke and rattling like a snoring pig. Lin and Wanda managed to get it on like a backpack BEFORE pressing 'GO.'</p>\
				 <p class='transient'>3-2-1</p>\
				 <p class='transient'>The jetpacks rocketed Lin and Wanda zipping over the track.  Eventually, they are above the smog and in a clear blue sky.</p>\
				 <p class='transient'>A message on the strap flashes: Approaching Jump</p>\
				 <p class='transient'>What could this mean? Jump where? Well, only <a href='landofftrackdpullpete'>one way to find out!</a></p>");
			}
		}
	}
);


//push pete		
undum.game.situations['landofftrackpushpete'] = new undum.SimpleSituation(
	"<p>By pushing him just right, he began to slide on his shlocks, and they pushed him all the way out of the den. But where to next?</p>\
		<ul class='options'>\
			<li><a href='landofftrackepete'>Go to the beach to find a way out</a></li>\
			<li><a href='landdownbattlepete'>Go to the battlefield of the Land Down Under</a></li>\
			</ul>",
	{
		enter: function (character, system, from) {
			character.sandbox.gotpete = true;
		}
	}
);
// Include a variable check for if they have Peter or not. 

undum.game.situations['landofftrackepete'] = new undum.SimpleSituation(
	"<p>At the beach, they found a little dingy -- a little boat that is -- into which they placed Pete for safe keeping, since he was so out <a href='landofftracke'>of it still.</a></p>"
);


undum.game.situations['landofftracke'] = new undum.SimpleSituation(
	"<p>When they reached the beach again, the scene had changed.  The No-trackers had fitted all the people with their shoes and now the people of the Land Down Under were standing up and playing ball and laughing -- that was a sound Lin hadn't heard since she'd first entered <a href='landofftracke1'>the basement.</a></p>"
);


undum.game.situations['landofftracke1'] = new undum.SimpleSituation(
	"<p>And there, halfway up the beach, was a sight that almost blew Lin down to the ground, which wasn't hard considering she was still made of paper.  A boat. A little rowboat. And it wasn't even made of paper. Or was it - -yes, paper mache!</p>\
		<p>'Look at that dingy,' said Lin.</p>\
		<p>'Don't call me that,' protested Wanda.</p>\
		<p>'No, not you, over there, that dingy!'</p>\
		<p>'All right, I've had just about enough of you! You're jealous of me aren't you?'</p>\
		<p>'What? I was talking about -- what would I <a href='landofftracke2'>be jealous of?'</a></p>"
);




undum.game.situations['landofftracke2'] = new undum.SimpleSituation(
	"<p>'Well, for one, how I look.'</p>\
		<p>Lin almost rolled her paper eyes right out of her two-dimensional head.</p>\
		<p>'We look EXACTLY the same.'</p>\
		<p>'But I wear the same... better.'</p>\
		<p>'What does that even mean?' asked Lin.</p>\
		<p>'You know.'</p>\
		<p>Lin shook her head.</p>\
		<p>'Well, they all know.' Wanda said, gesturing to the happy, playing flat people who, of course, were paying no attention to either Lin or Wanda.</p>\
		<p>'They all look the same, <a href='landofftracke3'>too!' said Lin.</a></p>"
);



undum.game.situations['landofftracke3'] = new undum.SimpleSituation(
	"<p>And then Wanda looked around her as if for the first time.  It was as if the consequences of their identical bodies had not yet hit her, as if until then, she had actually perceived those around her as looking different, lesser. She knew in her head (where most of us know things) that she looked the same, but in some other part of her (her stomach perhaps) she clung to the belief that she looked different.  And there with that clinging stomach to which she had held on so tightly -- well, now this is just <a href='landofftracke4'>getting disgusting.</a></p>"
);


undum.game.situations['landofftracke4'] = new undum.SimpleSituation(
	"<p>And when the realization finally hit her, that they were actually all the same and so she couldn't look any better than anyone, just the same, all that rolled out of her mouth, like a gumball down a long and windy spiral chute, was the <a href='landofftracke5'>little word, 'oh.'</a></p>"
);


undum.game.situations['landofftracke5'] = new undum.SimpleSituation(
	"<p>The smug smile that Lin had been saving up in a little treasure chest for just that moment, didn't look like a shiny tiara anymore but like a dingy cheap piece of dress-up jewelry.  So she just <a href='landofftracke6'>let it drop.</a></p>"
);


undum.game.situations['landofftracke6'] = new undum.SimpleSituation(
	"<p>'Let's get in the boat.'</p>\
				<p>'Oh, the dingy?' asked Wanda.</p>\
				<p>And Lin decided instead of strangling the girl, throttling her, shaking her back and forth like a paper rag doll -- <a href='landofftrackf'>to laugh.</a></p>"
);



// The boat has bones in them:

//Choice -- get in the Boat or Don't?
//[They're in the boat]


undum.game.situations['landofftrackf'] = new undum.SimpleSituation(
	"<p>'But row quickly further out to sea,' Lin said, 'Maybe we should wait a bit.'</p>\
				<p>But that was too much.  The last straw. The final enchilada.  The ultimate onion.</p>\
				<p>Now it was Wanda's turn to go off on someone, and no one ever likes to miss a chance to go off on someone.  'Lin, I'm sick of this!  It's as if you like this place or soemthing  And I bet I can guess why.'</p>\
				<p>Lin's heart started pounding.  She knew what was coming but felt like the deer in headlights, and she just couldn't stop it.</p>\
				<p>'Because here--'</p>\
				<p><a href='landofftrackf1'>Here it came.</a></p>"
);

undum.game.situations['landofftrackf1'] = new undum.SimpleSituation(
	"<p>'Down here -- where we've been transformed into this --'</p>\
				<p>Yup.</p>\
				<p>'We're all exactly the same.  And --'</p>\
				<p>Right, she'd have to go here, too.</p>\
				<p>'You don't look so funny.  You look just the same. You look normal.'</p>\
				<p>Yep, there it was.  She'd said it. Now it was out there.  Lin stared at the words like a fish, flopping on the deck of the boat, with its last little flaps as the life went out of it.</p>\
				<p>One moment, uno momento, ein minuten! I can't just let that little fish die here on the deck -- even if it's just in a metaphor -- or simile, rather.  Lin picked up the fish and prepared to throw it into the water, when she burst <a href='landofftrackf2'>out with -- </a></p>"
);


undum.game.situations['landofftrackf2'] = new undum.SimpleSituation(
	"<p>'You're right.'</p>\
				<p>Wanda stared at her.</p></p>\
				<p> The fish -- if you're worried -- didn't go into the water at all, but sprouted rainbow colored wings and flew off.</p>\
				<p>'And the reason you don't want to leave,' said Lin, 'Is that you're afraid to.'</p>\
				<p>'Afraid of what?' Wanda bark-laughed-snorted-coughed. 'What am I afraid of?'</p>\
				<p>'You're afraid,' Lin said, but not in a mean way, 'that you're different, too -- that you're just as different as me.'</p>\
				<p>And now that it was out, the girls did the only thing they could do -- well, they could've sensibly agreed, shook hands, smiled, hugged, but let's fact it, that's not what happens.  Instead they shoved and tussled and pushed until they fell <a href='landofftrackf3'>off the boat.</a></p>"
);

// Where is Peter?

undum.game.situations['landofftrackf3'] = new undum.SimpleSituation(
	"<p>The water was a cold slap of reality like brain freeze.  They splashed about for some time before they realized that the only way to keep their flat bodies afloat was to lie perfectly still. However, without the protective wrap, Lin felt the water filling her, and she was getting soggy.  She remembered how easily wet paper tore and realized they'd have to be careful.</p>\
				<p>'Gross,' said Wanda. 'I've never gotten wet since I've been here.'</p>\
				<p>'Better be still for a while,' said Lin. 'We don't want to rip.'</p>\
				<p>'Looks like rain <a href='landofftrackf4'>is coming, too.'</a></p>"
);


undum.game.situations['landofftrackf4'] = new undum.SimpleSituation(
	"<p>On the horizon, Lin spied some gathering clouds.  'Bring it on,' Lin thought.  Some rain might do them both [or all] some good, provided they could get back to the boat.</p>\
		<p>'Kick your legs back to the boat,' said Lin. 'If that storm gets here, we'll get separated.'</p>\
			<p>But now that she looked at it again, she could see that it wasn't a storm at all, but instead it was a ship, with billowy sails. It was still some distance off but would be upon them in no time, perhaps ten <a href='landofftrackf5'>minutes or so.</a></p>"
);



undum.game.situations['landofftrackf5'] = new undum.SimpleSituation(
	"<p>'Do you see it, Wanda?'</p>\
	<p>'Is that a pirate ship?'</p>\
	<p>	Now, it was clear to Lin. Flapping in the breeze atop the mainsail was the skull and cross bones.</p>\
	<p>Panic seized the girls.  They had to get back in that boat and what?  Could they outrow a massive pirate ship in a dingy?</p>\
	<p>They reached the edge of the boat.  Now <a href='landoffwandawaves'>how to get in?</a></p>"
);


/* The Wanda Crisis moment.   There are variations of this for each branch.		
		Wandas revelation
* pirate Ship:
Trying to get on Cap'n fred's ship
Don't rock the boat
Battle
When the butterflies are flying off
When the ticklemouses are getting trapped
*/

undum.game.situations['landoffwanda'] = new undum.SimpleSituation(
	"<p>Wanda tried to scream over the noise, screaming at Lin, telling her to DO something.  Anything. Lin couldn't quiet her mind enough to figure out what she could do.  She couldn't believe Wanda was acting so mean even during a moment like this, after all they'd been through.</p>\
	<p>Finally, Lin could <a href='landoffwanda1'>take it no more.</a></p>"
);


undum.game.situations['landoffwandawaves'] = new undum.SimpleSituation(
	"<p>Just then the sky turned dark.  Clouds that had been wisps in the distance, overtook them, and the sea became furious beneath them.</p>\
    <p>As the little dingy began to rock violently with the waves, Wanda began screaming, telling Lin to do something. Anything. Berating her. Belittling her. Lin couldn't quiet her mind above the shouting and the wind and the waves enough to figure out what she could do.  She couldn't believe Wanda was acting so mean even during a moment like this, after all they'd been through.</p>\
    <p>Finally, Lin could <a href='landoffwanda1'>take it no more.</a></p>"
);

/*Possibly add choices.
	Why do you have to be so mean? [Lin is bold]
	What is wrong with you?
	*/

// [These choices are cued by how you have choosing up till now?]


// BOLD -- Waat is wrong with you...

//[Because Lin is so bold, she could only say]

undum.game.situations['landoffwanda1'] = new undum.SimpleSituation(
	"<p>'Why do you have to be such a bully?' Lin said, turning to face her. 'You've been nothing but mean to me in Mrs. Wobbles' house.'</p>\
	<p>'I--' but for once, Wanda was speechless -- stunned, actually, at Lin being so, so -- bold.</p>\
	<p>'What did I ever do to you? Was I mean?' asked Lin. 'No. I just tried to make you feel welcome from the start, but right away you had to start making fun of me.' </p>\
	<p>Again Wanda was <a href='landoffwanda2'>completely silent.</a></p>"
);



undum.game.situations['landoffwanda2'] = new undum.SimpleSituation(
	"<p>'I mean, I know this isn't the time for it, but -- if we're going to try to make it out of here, I need to know you're going to help me and not hurt me.'</p>\
	<p>And there in the corner of Wanda's eyes, were the beginnings of tears, which she quickly wiped away at risk of losing her paper face to watery streaks.  She began speaking softly.</p>\
	<p>'But don't you remember,' said Wanda, 'that first night when you walked into the room when I was consoling Pete?'</p>\
	<p>Lin scanned her memory.  She could remember <a href='landoffwanda3'>no such conversation.</a></p>"
);


/* 
// Play it safe
	[Because Lin likes to Play it Safe, she could only say]
   'What do you want from me?" Lin said.  I'm doing everything I can.'
	'Then, everything you can is just not enough, clearly,' said Wanda.
	'But how could I do any more?' Lin asked exasperated.
	'Well, you could be more like me for one,' said Wanda.
	'But that's just it, I can't be more like you. I don't want to be more like you.'
	'Why not? Why the heck not?'
	'Because you're.... mean,' said Lin.  She hadn't wanted to say it, but she could hold it in no longer.' 

	'I don't want to be like this.  But it's how I protect myself. Don't you remember? on that first night at Mrs. Wobbles?'
	
	
	
	
// Timid.... 
[Because Lin is Timid, she could only say]
	'I'm sorry. I'm sorry. I'm sorry,' Lin kept repeating.  She just couldn't bare to have Wanda mad at her anymore.
	'I don't want you to be sorry. I want you to stand up for yourself.'
	'What?' asked Lin, honestly unable to understand what Wanda was trying to say.
	'I want you to be assertive.  I want you to be strong. I want you to be --'
	'More like you?' asked Lin.
	'Well, yeah, but in a Lin way.'
	'But that makes no sense.  I'm so different from you. I'm not trying to cause any...'
	'Trouble?' Wanda finished for Lin, 'But then, why did you flip the switch.'
	'I-I-' Lin couldn't find an easy answer except 'had to.'

	'Well, there you go.  I'm the way I am because I have to be. Don't you remember that first night at Mrs. Wobbles.'
	
	

*/




undum.game.situations['landoffwanda3'] = new undum.SimpleSituation(
	"<p>'Pete was crying.  You came in, and I explained it all.'</p>\
	<p>Lin just shook her head. 'No,' and then she added.</p>\
	<p>'Really,' asked Wanda?  'How could you forget such an important...' and now she was searching for a word, <a href='landoffwha'>'such an important...'</a></p>"
);

undum.game.situations['landoffwha'] = new undum.SimpleSituation(
	"<p>'Scene?' added Lin, completing her sentence. Now, that was an unusual word to use. 'Wait,' And now Lin started looking around, scanning from left to right, up and down. 'I feel like something is missing from this... story?' Now, that is odd.  Wanda had no idea what she was talking about, and to be honest, speaking for my part as the narrator, I do not appreciate the insinuation, although I believe she is speaking figuratively, metaphorically.</p>\
	<p>But Lin continued, 'I mean, the story of our lives. It's like there's <a href='landoffoops'>a section missing.'</a></p>"
);

undum.game.situations['landoffoops'] = new undum.SimpleSituation(
	"<p>All right, all right, hold the tale.  As the person, the being, singularly responsible for delivering story elements, I am a bit concerned that Lin's most recent statement suggests that I, the book, have somehow dropped the storytelling ball in some way.  And I want to assure you --</p>\
	<p>'Wait,' Wanda interrupted my narration, 'How could you not remember?' asked Wanda.  'That wasn't that long ago.'<p>\
	<p>Lin then proceeded to speak, as if to me, me, the book, 'It's like someone did not include that part of the story when they <a href='landoffoops1'>were telling it.'</a></p>"
);

undum.game.situations['landoffoops1'] = new undum.SimpleSituation(
	"<p><em>What is this? The Neverending Story? I'm getting tired of <a href='landoffoops2'>this meta-ness.</em></a></p>"
);

undum.game.situations['landoffoops2'] = new undum.SimpleSituation(
	"<p>But now that I think about it, there was this passage I vaguely recall -- oh, dear.</p>\
	<p><a href='landoffoops3'>Hmmmm.</a></p>"
);

undum.game.situations['landoffoops3'] = new undum.SimpleSituation(
	"<p>Um, okay, so this is a bit embarrassing, but I seem to have left out the most tiny chunk of this tale.  Page-balls!  It's getting worse.  All right, but I'm sure I can make up for it by just inserting it right here. How about you and I pretend that this had always been there -- except maybe much earlier in the story, okay?  Deal?</p>\
	<ul class='options'>\
		<li><a href='landoffoops3good'>Deal</a></li>\
		<li><a href='landoffoops3good'>Okay, deal.</a></li>\
		</ul>"
);


undum.game.situations['landoffoops3good'] = new undum.SimpleSituation(
	"<p>Great. Glad we are on <a href='landdowncry'>the same page.</a></p>"
);

// DEal or no deal Question

undum.game.situations['landdowncry'] = new undum.SimpleSituation(
	"<p>It was evening at Mrs. Wobbles house, as Lin was staring as was her way at the Land Down Under through the glass on the landing of the first step. What a perfect world, she thought. This was before the lava episode of the mysterious floor and well before the events to come in this tale.  Lin could distinctly hear the sound of a boy's muffled weeping, rolling down from upstairs, a quivering, shaking sound <a href='landdowncry1'>from deep inside.</a></p>"
);

undum.game.situations['landdowncry1'] = new undum.SimpleSituation(
	"<p>As she followed the sound, she found herself standing silently outside one of the boys' rooms. The door was closed, and she approached noislessly.  Listening at the door, she heard the two new kids, the siblings, Wanda and Pete.  Pete was sobbing.</p>\
	<p>'Pete, Pete, trust me, it'll be all right. It always is. We'll just do it the way we always do.'</p>\
	<p>Between sobs, Pete managed to mutter, 'They're gonna make fun of my drooling.  You know they are. They're already staring.  And what is <a href='landdowncry2'>this place anyway?'</a></p>"
);

undum.game.situations['landdowncry2'] = new undum.SimpleSituation(
	"<p>But Wanda was insistent. 'Hush. Once they get a load of what I can dish out, no one is gonna say a word.' It sounded more to Lin like Wanda was saying this more to practice her mean voice than to comfort her brother.</p>\
	<p>'But then,' said Peter between sobs, 'No one will like us.'</p>\
	<p>'What do you mean us? Me. No one will like me,' said Wanda. 'And that's okay. I can take it. I can take the hit for both of us.'</p>\
	<p>And gradually Pete <a href='landdowncry3'>stopped crying.</a></p>"
);

undum.game.situations['landdowncry3'] = new undum.SimpleSituation(
	"<p>That was when Lin did something, well, accidental. She sort of let her guard down a bit, leaning onto the door with a bit too much weight and pushing suddenly open.</p>\
	<p>Pete and Wanda looked at her with horror.  Wanda took a half second to restore her bully face before saying in the most foul voice she could muster, 'Hey, why're you spying on us, slanty mouth? Can't you give some new kids some privacy around here even <a href='landdowncry4'>for a minute?'</a></p>"
);

undum.game.situations['landdowncry4'] = new undum.SimpleSituation(
	"<p>And Lin, so upset by her own mistake, so flustered, so bothered by Wanda's insults, left in silence.  But from then on, whenever Wanda was insulting her, Lin knew -- she absolutely knew that this was not the act of meaningless meanness, but the act of a loving sister, protecting her brother.</p>\
	<p>It was as if she heard every insult, translated, not into something kind, but into an act of kindness.  An arrow that hit like a daisy, not that it wasn't <a href='landdowncry5'>still a bit annoying.</a></p>"
);

undum.game.situations['landdowncry5'] = new undum.SimpleSituation(
	"<p>Oh, dear, that scene was a little bit important to this plot.  Um, I really need to get this whole condition of mine looked into.  Who knows what other parts of the story I'm leaving out.  I may be becoming a -- perish the thought -- unreliable -- no, I can't even permit the words to appear on my pages.</p>\
	<p>Trust me. I will do my best. **cough, cough**. Let's get back to <a href='landofftrackf6'>where we were...</a></p>"
);


// Possible Choice Here	

undum.game.situations['landofftrackf6'] = new undum.SimpleSituation(
	"<p>'I can help you,' a voice said from in the boat.</p>\
	<p>And there from the boat the pile of bones had assembled into a person or <a href='landofftrackf7'>rather a skeleton.</a></p>"
);

undum.game.situations['landofftrackf7'] = new undum.SimpleSituation(
	"<p>'But you're a skeleton?'</p>\
	<p>'Aren't you sweet.  But look at me! Compared to you, I'm obese.'</p>\
	<p>'But we're just flat,' said Wanda.</p>\
	<p>'And how do you do it? What's your secret? Grapefruit juice? No carbs? Combining lunch and dinner and breakfast into one tiny meal called brunner?'</p>\
	<p>Lin rolled her eyes. 'Can you just help us into the boat?'</p>\
	<p>'Absolutely,' and he reached in and gently slid them onto the floor of the boat.</p>\
	<p>'Thanks,' Lin <a href='landofftrackf8'>said, 'Mister...?'</a></p>"
);

undum.game.situations['landofftrackf8'] = new undum.SimpleSituation(
	"<p>'First Mate Roberto Diego Espinoza Montoya the III,' said the bones, bowing, gracefully, his bones clacking like castanets. 'But you may call me Bob.'</p>\
	<p>'Bob?' Wanda and Lin said together.</p>\
	<p>'Oh, dear. It's because, you see, since I'm all bones, in the water, I just float up and down, you know--'</p>\
	<p>'Bob?' Wanda offered.</p>\
	<p>'What?' asked the skeleton.</p>\
	<p>'That's just cruel,' said Lin, but she couldn't help <a href='landofftrackf9'>laugh a bit.</a></p>"
);

undum.game.situations['landofftrackf9'] = new undum.SimpleSituation(
	"<p>It was good to be back in the boat, even though it was tiny and a pirate ship was bearing down on them.  Within a few minutes the stark heat of the sun had dried them to a salty crisp.  Lin wasn't entirely sure how durable they'd be in that newly dried out state.  They'd have to be ultra careful. </p>\
	<p>'Bob, can you help us row away from that boat?'</p>\
	<p>'Obviously!' and he grabbed a paddle and began to stroke at such speeds as Lin thought his arms would fall off, practically whirling like a pinwheel in the wind.</p>\
	<p>'Oh, that? That's just Captain Fred?'</p>\
	<p>Captain Fred? Pirate Bob?  'That's silly,' said Lin. 'But he is a Pirate, right?'</p>\
	<p>'Oh, yes, in fact he's responsible for me being like this.'</p>\
	<p>'He killed you?'</p>\
	<p>'No, he brought me back to life, well, more or less,' and at this bones glanced at his bony wrists and legs and frowned, as much as a skull can <a href='landofftrackf9a'>frown anyway.</a></p>"
);


undum.game.situations['landofftrackf9a'] = new undum.SimpleSituation(
	"<p>'Perhaps, I can be of help in a different form,' says Bob. On their confused loo, he added, 'I'm really just a bag of bones.  You could build me into something different, more useful.'</p>\
		<p>'But we like you as you are,' protested Lin. 'You don't need to change or us.'</p>\
		<p>'Right. Exactly! Don't need to, but can!  Isn't it better when you can change that you do change?'</p>\
		<p>Now if you don't mind, I need to check something with Bob briefly.  Or you can keep going.</p>\
		<ul class='options'>\
			<li><a href='landofftrackf9bob'>Let me talk with Bob.</li>\
			<li><a href='landofftrackf9bob2'>Just pick a new form for Bob</a></li>\
			</ul>"
);

//Consult with Bob

undum.game.situations['landofftrackf9bob'] = new undum.SimpleSituation(
	"<p>Oh, thank you.</p>\
		<p>Bob, sorry, but I think you're interfering with the theme of this story.</p>\
		<p>'How's that?' asked Bob. 'Shouldn't you be telling this story?</p>\
		<p>I will. I will. It's just.  You just told those girls you can be anything they want you to be, but isn't this a tale about valuing the person you are?</p>\
		<p>'Not sure how to say this, but theme really isn't my strong suit. They're in a little bit of a pickle thanks to you --'</p>\
		<p>Technically thanks to <a href='landofftrackf9bob1'>them because--</a></p>"
);

undum.game.situations['landofftrackf9bob1'] = new undum.SimpleSituation(
	"<p>'Splitting hairs, and I ain't got none, as the kids say. In any event, they're in a tough jam, and I just wanted to be of service.'</p>\
		<p>They'd be using you, though. Changing you.</p>\
		<p>'It's okay.  I can change back.  You should know that.'</p>\
		<p>Oh, all right then, I suppose. But I don't want any kids reading this to get the wrong idea.</p>\
		<p>'Well, hate to tell you this, but you should get out of the storytelling business if that's the case. Cheer up.  They'll at least enjoy the part <a href='landofftrackf9bob2'>with me in it.'</a></p>"

);


undum.game.situations['landofftrackf9bob2'] = new undum.SimpleSituation(
	"<p>All right then...(Those dots are my reservations about this path...)</p>\
		<p>How would you like Bob to help you?</p>\
		<ul class='options'>\
			<li><a href='landofftrackf9b3'>Turn into a shark and swim them around the back</a></li>\
			<li><a href='landofftrackf9b2'>Turn into a ladder you can use to board the ship.</a></li>\
			<li><a href='landofftrackf9b1'>Turn into xylophone  and play to someone the mermaids?</a></li>\
		</ul>"
);
/*
Choices:   Bob can help you...
		  Turn into a bird
		  Turn into a ladder
		  Turn into a xylophone
*/

//xylophone

undum.game.situations['landofftrackf9b1'] = new undum.SimpleSituation(
	"<p>Lickity-split, Bob disassembled and reassembled as a xylophone, upon which Lin began to play, recalling the piano lessons she had listened in on at her first foster home.  The music she played was pretty basic but was augmented by Pirate Bob's ooohs and ahhhs.</p>\
		<p>'That's music to my bones,' he said.  'You're better than a chiropracter.'</p>\
		<p>Soon they were surrounded by mermaids, all dancing and bobbing in the waves. It was a huge number with whales spouting fountains all on the sides and dolphins jumping and flipping above them. </p>\
		<p>Soon, the captain and crew of the ship were hanging over the side watching.  But when the music died down, they went back to what they were doing. </p>\
		<p>Maybe something else:</p>\
		<ul class='options'>\
		<li><a href='landofftrackf9b3'>Turn into a shark and swim them around the back</a></li>\
		<li><a href='landofftrackf9b2'>Turn into a ladder you can use to board the ship.</a></li>\
		</ul>"

);




// ladder	

undum.game.situations['landofftrackf9b2'] = new undum.SimpleSituation(
	"<p>Pirate Bob the skeleton fell to a pile of bones and then reassembled as their little boat reached the side of the giant ship into a ladder, running all the way up the side of the ship.  It seemed to Lin as though there must be some extra bones int there, but she decided not to think about it too hard.</p>\
		<p>Soon they were climbing up <a href='landofftrackf9b2a'>onto the ship.</a></p>"
);





undum.game.situations['landofftrackf9b2a'] = new undum.SimpleSituation(
	"<p>Captain Fred towered over them and said to his crew, 'All right, mateys, lock up these scaliwags in the brig.'</p>\
		<p>'JK, kiddos!' exclaimed the Captain.</p>\
		<p> 'Wait, what?' said Lin.</p>\
		<p>'JK'</p>\
		<p>'You know what that means, right?' </p>\
		<p>'I thought I did.  Ya say it when you're just joking around.'</p>\
		<p>'Wait? You were.'</p>\
		<p>'Yargh.'</p>\
		<p>'yargh?'</p>\
		<p>'Yeah, it's a portmentau of <a href='landofftrackf9b2b'>yes and argh!'</a></p>"
);


undum.game.situations['landofftrackf9b2b'] = new undum.SimpleSituation(
	"<p>Cap'n Fred was towering over them, but not on his old narwhale peg. Instead his stump had some sort of connector that attached him to a track in the ship -- a track that allowed him to glide around to any place he wished to access at quite a speed.</p>\
		<p>'It's of me own invention,' but a quick look at the mermaid lounging in a barrel of water on the deck, rolling her eyes, suggested it was not his idea at all.</p>\
		<p>No, track wasn't the word for it.  It was -- and Lin was straining to think <a href='landofftrackf9c'>of it -- a rut!</a><p>"
);



// Shark		

undum.game.situations['landofftrackf9b3'] = new undum.SimpleSituation(
	"<p>Pirate Bob collapsed into the water as a pile of bones and re-emerged as a shark -- well,a skele-shark. 'Hop on!' he said through multiple rows of shark teeth that had previously been finger and toe bones.</p>\
		<p>Lin and Wanda exchanged worried looks and then Wanda took the leap with Lin just behind her. </p>\
		<p>Soon they were shooting (or sharking) through the water to the back of the ship, where they found a ladder to sneak up to the deck in the back. And what they saw astounded them.</p>\
		<p>Cap'n Fred had replaced his Narwhal leg and flip flop, with something <a href='landofftrackf9b3a'>entirely different.</a></p>"
);

undum.game.situations['landofftrackf9b3a'] = new undum.SimpleSituation(
	"<p>It was a joint that attached him to a track that went all around the boat.  Yes, another track. Except this one wasn't going in one-direction but instead was made up of intersections and bends that helped him to glide around the ship wherever he wanted to go.  There was even a part that would raise him up to the crow's <a href='landofftrackf9b3b'>nest and back.</a></p>"
);

undum.game.situations['landofftrackf9b3b'] = new undum.SimpleSituation(
	"<p>'Woh!' exclaimed Lin before she realized she'd said anything. </p>\
	<p>'Woh is right,' added Wanda.</p>\
	<p>'Whah?' said Cap'n Fred, gliding to a stop before them. 'Oh, this? Me little contraption.  Just a little invention of mine. Gets me where I need to go.'</p>\
	<p>'It's awesome said,' Lin.</p>\
	<p>And at that compliment, Cap'n <a href='landofftrackf9b3c'>Fred teared up.</a></p>"
);

undum.game.situations['landofftrackf9b3c'] = new undum.SimpleSituation(
	"<p>'You been on a track, haven't ya? It's fun.'</p>\
	'But we couldn't choose where we go'</p>\
	'Then I wouldn't call it a track at all,' said Cap'n Fred. <a fref='landofftrackf9c'>'That be a rut.'</a></p>"
);



// a rut	
undum.game.situations['landofftrackf9c'] = new undum.SimpleSituation(
	"<p>And suddenly it became clear to Lin that he was right. She had been in a rut, not just in the Land Down Under, but up above.  A rut that made her always wish that she were somehow different from the way she was -- or really, that she was the same as everybody else. </p>\
		<p>But looking at the one-legged pirate captain or the bag of reshuffable bones that was pirate Bob or even Wanda, she realized that she with her crooked smile offered something no one else could. Lin-ness.  Not to mention, her smile was only crooked if all smiles had to be a completely straight line-- which of course no <a href='landofftrackf9c1'>smile is.</a></p>"
);


// End Pirate Fred ending -- though there are other parts to this ending:
// like a whale that swallows them, or sailing to the exit
// Or going down into a whirlpool....

undum.game.situations['landofftrackf9c1'] = new undum.SimpleSituation(
	"<p>With that realization, she was ready to go home.  And that's just where Cap'n <a href='landofftrackf9c2'>Fred took them.</a></p>"
);


undum.game.situations['landofftrackf9c2'] = new undum.SimpleSituation(
	"",
	{
		enter: function (character, system, from) {
			if (character.sandbox.gotpete == true) {
				system.write("<p>He sailed them all the way to the portal, and Lin, Wanda, and Pete returned to the basement of Mrs. Wobbles' Tangerine House and their former three-dimensional -- four dimensional actually, because of time -- selves.  And all went more or <a href='landdownendpete'>back to normal.</a><p>");
			}
			else {
				system.write("<p>He sailed them all the way to the portal, and Lin and Wanda -- without Pete -- returned to the basement of Mrs. Wobbles' Tangerine House, where they were restored to their former selves, assuming you can ever go back to who you were after a journey <a href='landdownpeteless'>such as that.</a></p>");
			}
		}
	}

);




/* paths in


*/




// The Big Battle
// IF said hi to Timmmy, he shows up with his Zeppelin
// If friends with Timmy, he leads a mighty army.  	

undum.game.situations['landdownbattlepete'] = new undum.SimpleSituation(
	"<p>Getting Pete to the battlefield was not easy, but they found that since everyone had left the track, it was a clear path for moving Pete in his shlocks, which fit perfectly.  When they reached the battle, they found a safe place for him until the battle ended, <a href='landdownbattle'>assuming it would.</a>"
);


undum.game.situations['landdownbattle'] = new undum.SimpleSituation(
	"<p>All across the Land Down Under.  The two sides prepared for battle.  On the one side, the King and his devoted followers prepared their watery assault weapons.  On the other, the Queen's ragtag rebels, whose ranks had grown a hundred fold since the flip of the switch. </p>\
	<p>Whose speech would you like to listen to?</p>\
	<ul class='options'>\
		<li><a href='landdownbattlequeen'>The Queen's Speech</a></li>\
		<li><a href='landdownbattleking'>The King's Speech</a></li>\
		<ul>"
);


undum.game.situations['landdownbattleking'] = new undum.SimpleSituation(
	"<p>The King who had risen to the surface of the water, mohawk flaring straight up in the sun, began in grave tones, 'When a people are divided into two groups, there are usually two ways to solve the problem.  One, is almost never chosen.  That is to reconcile, to make amends, to lay down hostilities and find common ground.  The other is more common, so common in fact we have a name for it.  A very old name.  A very cold name. <a href='landdownbattle1'>And that is...</a></p>"
);


//Maybe they have a choice of whose speech to listen to.

undum.game.situations['landdownbattlequeen'] = new undum.SimpleSituation(
	"<p>Standing before them in her torn paper jacket, the Queen was also giving a speech.</p>\
	<p>'Civil wars are like divorces: They are not the kind of battles you fight to win because every hit is a wond, every victory, a loss, and to win is to reach a point where you finally admit defeat.'</p>\
	<p>All who listened were greatly moved. Including me.  That's <a href='landdownbattle1'>some heavy stuff.</a>"
);

undum.game.situations['landdownbattle1'] = new undum.SimpleSituation(
	"<h1>Civil War</h1>\
	<p>Ah, the serious battle. All right.  Although, since the battle is taking place in a mostly two-dimensional world with miniature combatants, it will not seem that serious. In fact, it will seem the way distant wars or wars from the past feel like in the real world. The kind that pose no threat to you or me.</p>\
	<p>But trust me, the consequences of this war were very real for those brave paper men and women <a href='landdownbfcourage'>who were involved.</a></p>"
);

/*
	<p>However, now that we are off the tracks, as it were, you have a choice over how this war transpires.  Would you like<p>\
	<ul class='options'>\
		<li><a href='landdownbattlefrown'>a more serious battle</a></li>\
		<li><a href='landdownbattlesmile'>a more light hearted battle</a></li>\
	</ul>"

*/


// SERIOUS BATTLE TANGENT	Work on TRANSITION'


undum.game.situations['landdownbfcourage'] = new undum.SimpleSituation(
	"",
	{
		enter: function (character, system, from) {
			switch (character.qualities.courage)
			{
			case 1:
				system.write("<p>Lately, you have been mostly bold, so your battle style <a href='landdownbfbold'>follows that track.</a></p>");
			break;
			case 2:
				system.write("<p>Lately, you have mostly played it safe, so your battle style <a href='landdownbfsafe'>follows that track.</a></p>");
			break;
			case 3:
				system.write("<p>Lately, you have been mostly timid, so your battle style <a href='landdownbftimid'>follows that track.</a></p>");
			break;
			}
		}
	}
);

// Bold Serious Battle
// Change this to bombing homes   of LDUs

undum.game.situations['landdownbfbold'] = new undum.SimpleSituation(
	"<p>Having been bold up till now, you decide take command of a set of troops, butterfly brigades, dropping water balloons willy nilly -- including, oh, dear on top of a pile of -- what are those, mud bubbles?  Something that looks like stacks of mud bubbles, all tumble down and out from them, roll some very upset ticklebugs.</p>\
	<p>Wanda looked down, 'What a mess! You're pretty aggressive. You better help them rebuild.' But if you help them rebuild, you may lose time. </p>\
	<ul class='options'>\
		<li><a href='landdownbfboldtrebuild'>Help them rebuild their stack</a></li>\
		<li><a href='landdownbfboldtfight'>Fight them off?</a></li>\
		</ul>"
);


// Fight them off
undum.game.situations['landdownbfboldtfight'] = new undum.SimpleSituation(
	"<p>Have you ever wrestled a pile of spaghetti noodles with arms like feather dusters?  I don't recommend it.  That is what it felt like to fight a colony of ticklebugs, also knowns as a giggle of tickle bugs.  It was completely futile and hilarious.  Despite not having liquid in her paper body, Lin several times felt on the verge of peeing, she laughed so hard.</p>\
	<p>Fortunately, Wanda was able <a href='landdownbfboldtwanda'>to pull her out.</a></p>"
);


	undum.game.situations['landdownbfboldtrebuild'] = new undum.SimpleSituation(	
		"<p>Although it consumed quite a bit of valuable time, Lin and Wanda set about helping the ticklebugs restack their mud bubbles.  In response, the tickle bugs seemed grateful and at least didn't tickle Lin and Wanda, while <a href='landdownbfboldtwanda'>they were there.</a></p>"
	);

undum.game.situations['landdownbfboldtwanda'] = new undum.SimpleSituation(
	"<p> Wanda turned to Lin, 'You're going full throttle. You sure you don't want to back off a bit?'</p>\
	<p>But Lin had already <a href='landdownbfboldthrottle'>made her choice.</a></p>"
	);
	
//	Maybe take your foot off the petal -- Add thie option later

undum.game.situations['landdownbfboldthrottle'] = new undum.SimpleSituation(
	"<p>'Full throttle,' said Lin.</p>\
	<p>She could tell Wanda didn't know what she meant by this until they were already getting wrapped up in their plastic suits.</p>\
	<p>'We're going for the King!' said Wanda, almost in disbelief. 'Okay.' But Wanda was smiling.  <a href='landdownbfboldthrottle1'>Impressed even.</a></p>"
	);

undum.game.situations['landdownbfboldthrottle1'] = new undum.SimpleSituation(
		"<p>Down to the King's underwater lair they descended and as they approached his castle, free to approach however they chose, they slid up along the sides, so they could listen in.</p>\
		<p>'Take the 11th squadron up through the school. They won't suspect that.  Then, the troops through the factory can close off their retreat.'</p>\
		<p>This was bad. The folders would be routed.  There would be no escape.  Lin had only a moment to act and soon <a href='landdownbfboldthrottle2'>she had jumped out.</a></p>"
	);

undum.game.situations['landdownbfboldthrottle2'] = new undum.SimpleSituation(
	"<p>The King gave an almost imperceptible start and then smiled, baring his fangs. [Silly, which needed brushing]</p>\
	<p>'You, I did not expect to you see after that little stunt where you flipped the switch. I just assumed you would return to the world up above, to your fancy houses, your three dimensions -- or is it four -- and all your free movement…'</p>\
	<p>Lin was a little surprised the King knew about the land up above but decided not to show it.</p>\
	<ul class='options'>\
		<li><a href='landdownbfboldthrottle1yes'>Yes, free, I like being free</a></li>\
		<li><a href='landdownbfboldthrottle1no'>No, that's not what Freedom is.</a></li>\
		</ul>"
	);

undum.game.situations['landdownbfboldthrottle1yes'] = new undum.SimpleSituation(
	"<p>'Yes, free,' Lin shouted, 'I like being free.  And so do your people!'</p>\
	<p>'Oh, yes, everyone loves freedom.  Freedom from responsibility, freedom to do as we please, freedom from promises we made to those we love...</p>\
	<p>Suddenly, Lin got the feeling that the King was not talking about her but about the Queen. At the same time, she got the feeling that a giant snake was wrapping <a href='landdownbfboldthrottle2'itself around her.'</a></p>"
);

undum.game.situations['landdownbfboldthrottle1no'] = new undum.SimpleSituation(
	"<p>'No, no, you don't understand,' said Lin. 'Freedom doesn't mean we just do whatever we want.  Freedom makes our choices matter. Because if we choose something, like friendship, it matters all the more.' Lin began thinking of Pete and Wanda, families of choice, as they say.</p>\
	<p>'But people never choose other people in the end,' said King, 'for that is too much work. And no one wants to do work.'</p>\
   <p><a href='landdownbfboldthrottle2'>You don't.'</a></p>"
   );

   undum.game.situations['landdownbfboldthrottle2'] = new undum.SimpleSituation(
   "<p>But their conversation was interrupted by an explosion of bubbles, as the Queen herself descended into the water in a gleaming submersible.</p>\
   <p>'Speak of the devil,' said the King.</p>\
   <p>And no sooner had the submersible reached Lin but she found herself being drawn into it by robot arms only to have it rocket back up through the water and out into <a href='landdownbfboldthrottle3'>safe dry land.</a></p>"
   );

   undum.game.situations['landdownbfboldthrottle3'] = new undum.SimpleSituation(
   "<p>'You okay, topsider?' asked the Queen.</p>\
   <p>'Yeah, I'm okay.  But I think you need to talk with the King.'</p>\
   <p>'Talk? With the King? . That's funny' said the Queen, 'But I think it is too late for that.'</p>\
   <p>And then, Lin remembered something Mrs. Wobbles had once said to her, 'A relationship is like a never ending conversation.</p>\
   <p>The only thing that can hurt it, can kill it actually, is when you just don't feel like giving a reply.'</p>\
   <p>'That sounds like a lot of talking,' Lin said, kind of sarcastically.</p>\
   <p>'When the conversations that good, you don't want it to end.' And with that she gave a wink and was quiet for a long time.  If Lin wasn't so good at understanding metaphors, she would have missed the irony altogether.  But nothing felt better than sitting next to Mrs. Wobbles when she had just dropped some wisdom on you and was letting you soak your <a href='landdownbattleserioustrans'>feet in it.</a></p>"
   );
   
   
   // End of Bold Battle


// The Play it Safe Serious Battle

undum.game.situations['landdownbfsafe'] = new undum.SimpleSituation(
	  "<p>Lin's approach to battle, like her approach to life was to play it safe.   That meant troups taking a fairly cautious, but practical route, even leaving a few to hang back. She was the goldilocks of paper generals.  And it seemed a good plan because no one expected anything from her -- no interruptions, no sudden orders.</p>\
	<p>At one point, she noticed some ticklebugs [if you know what they're called] over in the corner.  You now, despite their fuzzy spidery-ness, they were quite cute. She wonderedwhat it would be like to tickle them.</p>\
	<ul class='options'>\
		<li><a href='landdownbfsafepet'>Pet the ticklebugs</a></li>\
	    <li><a href='landdownbfsafenopet'>Are you kidding? No way.</a></li>\
	</ul>"
	);


	// Pet the ticklebugs...
undum.game.situations['landdownbfsafepet'] = new undum.SimpleSituation(
	"",
	{
		enter: function (character, system, from) {
			if (character.sandbox.metsafe == true){
	system.write("<p>Lin walked slowly but directly over to the cluster of ticklebugs and reached out her hand. At first, they stopped completely still.</p>\
	<p>'Aw,' she said, 'you must not be used to people being nice to you.'</p>\
	<p>She reached her hand further and felt the soft fur on its many legs. It was like the feeling of a fuzzy sweater. Cozy. Soft. And -- tickly.  When Lin started laughing, she knew it was too late.  The bugs had quickly found all of her tickle spots.  And she was laughing uncontrollably.</p>\
	<p>'Lin! Lin!' cried out Anna, but Lin could not reply. She couldn't even gasp for breath. Would she die from laughter? She felt herself getting light-headed.  Which was when a paper arm violently yanked her away from the bugs, sending them tumbling into a little pile.</p>\
	<p>'Lin, what were you thinking?'</p>\
	<p>'They just seemed so cute.'</p>\
	<p>'Never let <a href='landdownbfsafereturn'>your guard down!</a></p>")
			}
		else {
		system.write("<p>Lin walked slowly but directly over to the cluster of ticklebugs and reached out her hand. At first, they stopped completely still.</p>\
		<p>'Aw,' she said, 'you must not be used to people being nice to you.'</p>\
		<p>She reached her hand further and felt the soft fur on its many legs. It was like the feeling of a fuzzy sweater. Cozy. Soft. And -- tickly.  When Lin started laughing, she knew it was too late.  The bugs had quickly found all of her tickle spots.  And she was laughing uncontrollably.</p>\
		<p>'Lin! Lin!' cried out Anna, but Lin could not reply. She couldn't even gasp for breath. Would she die from laughter? She felt herself getting light-headed.  Which was when a paper arm violently yanked her away from the bugs, sending them tumbling into a little pile.</p>\
		<p>'Lin, what were you thinking?'</p>\
		<p>'I don't know, Anna, They just seemed so cute'</p>\
		<p>'Call me Safe. The Folders know me as Safe T. Scissors.'</p>\
		<p>Whoa. I want a code name,' said Lin.</p>\
		<p>'First, survive. And remember, never let <a href='landdownbfsafereturn'>your guard down!'</a></p>");
			}
		}
	}
);


// Don't pet them.
undum.game.situations['landdownbfsafenopet'] = new undum.SimpleSituation(
	"",
	{
		enter: function (character, system, from) {
			if (character.sandbox.metsafe == true){
	system.write("<p>Lin hadn't realized how close she'd gotten to the creatures. Those tickle bugs were cute - and probably adorably soft, but Lin knew better.</p>\
	<p>'Good call,' Safe said from behind her.  'We've lost more fighters to tickle bugs than <a href='landdownbfsafereturn'>to anything else.'</a></p>");
			}
			else {
	system.write("<p>Lin hadn't realized how close she'd gotten to the creatures. Those tickle bugs were cute - and probably adorably soft, but Lin knew better.</p>\
	<p>'Good call,' Anna said from behind her.  'We've lost more fighters to tickle bugs than to anything else. </p> \
	<p>'Anna!' exclaimed, hugging her.</p>\
	<p>'Safe T. Scissors is my Folder name. These ladies know me as Safe.'</p>\
	<p>'Wait, you have code names?' <a href='landdownbfsafereturn'></a>Lin was in awe. </a></p>");
	character.sandbox.metsafe = true;
			}
		}
	}
	);

// Rejoin
undum.game.situations['landdownbfsafereturn'] = new undum.SimpleSituation(
	"<p>Their chat was interrupted by returning battalions, some injured badly..</p>\
	<p>'We're stuck out there,' said one commander, 'It's like we're doing what they expected.'.</p>\
	<p>'But, I'm just playing it safe. It's a long war,' said Lin.</p>\
	<p>'Not for us,' said the Commander, 'We keep like this and they're gonna grind us down.'.</p>\
	<p>Lin wasn't sure what to do.  She had always been the cautious sort.'Grab a <a href='landdownbfsafereturn1'>sash,' said Safe.</a></p>"
	);


undum.game.situations['landdownbfsafereturn1'] = new undum.SimpleSituation(
	"<p>Lin looked over and saw that the wall lined with sasha like the ones Safe wore. Lin had never looked too closely at them.'Pick the one that suits you.'</p>\
	<p>'Suits me?'</p>\
	<p>As she looked closer, she saw that the sashes had names on them. Harriet Tubman. Marie Currie, Toni Morrison, Susan B, Anthony, Mary Wollstencraft, Malala Yousafzai, Rosa Parks. Lin chose Toni Morrison, the writer of many amazing and <a href='landdownbfsafereturn2'>powerful tales.</a></p>"
	);


/* The Sash choice
undum.game.situations['landdownbfsafereturn2'] = new undum.SimpleSituation(
	"",
	{
		enter: function (character, system, from) {
	 Harriet Tubman
	 Marie Currie
	 Toni Morrison
	 Susan B, Anthony
	 Mary Wollstencraft
	 Malala Yousafzai
	 Rosa Parks
	 "
);
*/



// Rejoin
undum.game.situations['landdownbfsafereturn2'] = new undum.SimpleSituation(
	"<p>'What would've happened to them if they'd just played it safe?'</p>\
	<p>Safe and Lin mounted paper airplanes.  Before she knew it, they had flown over the troops, locked in an even battle with the King's forces.</p>\
	<p>'Up there,' said Safe. and Lin followed her finger's direction to a squadron of mushroom guards.</p>\
    <ul class='options'>\
 	<li><a href='landdownbfsafereturnwater'>Water</a></li>\
    <li><a href='landdownbfsafereturnsalt'>Salt</a></li>\
 </ul>"
);
 
 undum.game.situations['landdownbfsafereturnsalt'] = new undum.SimpleSituation(
  "<p>As the salt fell upon the domed heads of the mushroom guard, it bore tiny holes and shrivveled them up.</p>\
  <p>'Good thing I like to experiment with salad,' said Lin as she <a href='landdownbfsafereturn2'>watched them retreat.</a></p>"
 ); 

 // water			 
 
undum.game.situations['landdownbfsafereturnwater'] = new undum.SimpleSituation(
	"<p>As Lin tossed water on their mushroom guard, she at first watched them shake their heads in irritation but soon they were back to their selves.  Fortunately, Safe had some salt of her own, and when she lobbed it at them, they ran away screaming.</p>\
	<p>'Run away, you cowards, before we come down there and eat you!' she shouted, <a href='landdownbfsafereturn2'>whooping with joy.</a></p>"
	);
 
 
 undum.game.situations['landdownbfsafereturn2'] = new undum.SimpleSituation(
	"",
	{
		enter: function (character, system, from) {
			if (character.sandbox.metsafe == true){
 	system.write("<p>That battle turned the tide for the folders.  Without the elite mushroom guard, the King would be basically defenseles.</p>\
	 <p>Safe and Lin returned to the camp badly wounded, streaks of water down their arms and legs and some mushyness near her belly. But her spine felt stronger and she knew she'd face the next battle with more might! At camp they regrouped with the other folders who were in equally bad shape.  Hole Punch had strips of paper patching up her shoulder but wore a proud  <a href='landdownbattleserioustrans'>smile on her face.<a></p>");
			} 
			else {
	system.write("<p>That battle turned the tide for the folders.  Without the elite mushroom guard, the King would be basically defenseles.</p>\
	<p>Safe and Lin returned to the camp badly wounded, streaks of water down their arms and legs and some mushyness near her belly. But her spine felt stronger and she knew she'd face the next battle <a href='landdownbattleserioustrans'>with more might!<a></p>");
				}			
			}
		}
	);

// End Battle Serious Bold

// Battle Serious timid
undum.game.situations['landdownbftimid'] = new undum.SimpleSituation(
	"<p>As the battle waged on between the air and water forces, Lin found herself with scores of paper children hunkered down in the school building. Cowering under desks.  Hoping for the best.  Fearing every sound could be a watery meteor tearing through the ceiling and destroying <a href='landdownbftimid1'>the whole structure.</a></p>"
);


// Possibly try things other than hushing them...
undum.game.situations['landdownbftimid1'] = new undum.SimpleSituation(
	"<p>'Well, at least I'm safe,' she said to hereself.</p>\
	<p>And that's when the giggling broke out. First, little spurts and sputters.</p>\
	<p>This was no good. She tried to hush them.</p>\
	<p>Then, more clusters.</p>\
	<p>What was so funny?</p>\
	<p>And at last it over took the whole group, and then her.</p>\
	<p>It wasn't a joke. Not a case of the giggles but instead the look hairy arms of the tickle bugs, doing what they did best.  She <a href='landdownbftimid2'>was losing control.</a></p>"
);


undum.game.situations['landdownbftimid2'] = new undum.SimpleSituation(
"<p>That was enough.  Enough hiding.  Enough cowering. Enough folding down into crash position.  It was time to be <a href='landdownbftimid3'>a bit more bold.</a></p>"
);

undum.game.situations['landdownbftimid3'] = new undum.SimpleSituation(
	"<p>Scanning the room, for something, her eyes hit upon something that just might work.</p>\
	<ul class='options'>\
		<li><a href='landdownbftimidpointer'>The teacher's pointer</a></li>\
		<li><a href='landdownbftimidalpha'>The alphabet scroll</a></li>\
	</ul>"
);

undum.game.situations['landdownbftimidpointer'] = new undum.SimpleSituation(
"<p>Soon, the teacher's pointer was in her hand, and she was prying a ticklebug off a child. However, once it let go, she sent it flying toward the front of the class, toward the turning paper town board, which dragged the tickle bugs toward the side of the room.  Some splatted against the wall, but most made mad leaps out the classroom door, so disoriented that they bumped into each other more trying to find their way out of the school.  It was hilarious, and the kids would've laughed if they weren't exhausted already from laughter. Now, that she had successfully battled the tickle bugs. She felt renewed confidence to join Wanda <a href='landdownbattleserioustrans'>and the others in battle!</a></p>"
);

undum.game.situations['landdownbftimidalpha'] = new undum.SimpleSituation(
	"<p>Just above the scrolling blackboard was the alphabet -- another insult -- didn't these kids already know their alphabet.  Snatching it and tearing off a little swath (all the way about to G), she rolled it up and then snapped it at the ticklebugs like a towel whip.  With each snap, they gave off a little yelp, and soon all of them had run out of the room.  With renewed confidence from her alphabetical whipping, Lin felt that she could head back into battle and join <a href='landdownbattleserioustrans'>Wanda and the others.</a></p>"
);

// transition	

undum.game.situations['landdownbattleserioustrans'] = new undum.SimpleSituation(
	"<p>The noise of a battle churning into acting was deafening. And confusing.  Everywhere people were running and shouting.  And confusion, as you probably know, can make people very upset, <a href='landoffwandaserious'>angry even.</a></p>"
);



undum.game.situations['landoffwandaserious'] = new undum.SimpleSituation(
	"<p>Wanda tried to scream over the noise, screaming at Lin, telling her to DO something.  Anything. Lin couldn't quiet her mind enough to figure out what she could do.  She couldn't believe Wanda was acting so mean even during a moment like this, after all they'd been through.</p>\
	<p>Finally, Lin could <a href='landoffwanda1serious'>take it no more.</a></p>"
);



/*Possibly add choices.
	Why do you have to be so mean?
	What is wrong with you?
	*/

undum.game.situations['landoffwanda1serious'] = new undum.SimpleSituation(
	"<p>'Why do you have to be such a bully?' Lin said, turning to face her. 'You've been nothing but mean to me in Mrs. Wobbles' house.'</p>\
	<p>'I--' but for once, Wanda was speechless -- stunned, actually, at Lin being so, so -- bold.</p>\
	<p>'What did I ever do to you? Was I mean?' asked Lin. 'No. I just tried to make you feel welcome from the start, but right away you had to start making fun of me.' </p>\
	<p>Again Wanda was <a href='landoffwanda2serious'>completely silent.</a></p>"
);

undum.game.situations['landoffwanda2serious'] = new undum.SimpleSituation(
	"<p>'I mean, I know this isn't the time for it, but -- if we're going to try to make it out of here, I need to know you're going to help me and not hurt me.'</p>\
	<p>And there in the corner of Wanda's eyes, were the beginnings of tears, which she quickly wiped away at risk of losing her paper face to watery streaks.  She began speaking softly.</p>\
	<p>'But don't you remember,' said Wanda, 'that first night when you walked into the room when I was consoling Pete?'</p>\
	<p>Lin scanned her memory.  She could remember <a href='landoffwanda3serious'>no such conversation.</a></p>"
);

undum.game.situations['landoffwanda3serious'] = new undum.SimpleSituation(
	"<p>'Pete was crying.  You came in, and I explained it all.'</p>\
	<p>Lin just shook her head. 'No,' and then she added.</p>\
	<p>'Really,' asked Wanda?  'How could you forget such an important...' and now she was searching for a word, <a href='landoffwhaserious'>'such an important...'</a></p>"
);

undum.game.situations['landoffwhaserious'] = new undum.SimpleSituation(
	"<p>'Scene?' added Lin, completing her sentence. Now, that was an unusual word to use. 'Wait,' And now Lin started looking around, scanning from left to right, up and down. 'I feel like something is missing from this... story?' Now, that is odd.  Wanda had no idea what she was talking about, and to be honest, speaking for my part as the narrator, I do not appreciate the insinuation, although I believe she is speaking figuratively, metaphorically.</p>\
	<p>But Lin continued, 'I mean, the story of our lives. It's like there's <a href='landoffoopsserious'>a section missing.'</a></p>"
);

undum.game.situations['landoffoopsserious'] = new undum.SimpleSituation(
	"<p>All right, all right, hold the tale.  As the person, the being, singularly responsible for delivering story elements, I am a bit concerned that Lin's most recent statement suggests that I, the book, have somehow dropped the storytelling ball in some way.  And I want to assure you --</p>\
	<p>'Wait,' Wanda interrupted my narration, 'How could you not remember?' asked Wanda.  'That wasn't that long ago.'<p>\
	<p>Lin then proceeded to speak, as if to me, me, the book, 'It's like someone did not include that part of the story when they <a href='landoffoops1serious'>were telling it.'</a></p>"
);

undum.game.situations['landoffoops1serious'] = new undum.SimpleSituation(
	"<p><em>What is this? The Neverending Story? I'm getting tired of <a href='landoffoops2serious'>this meta-ness.</em></a></p>"
);

undum.game.situations['landoffoops2serious'] = new undum.SimpleSituation(
	"<p>But now that I think about it, there was this passage I vaguely recall -- oh, dear.</p>\
	<p><a href='landoffoops3serious'>Hmmmm.</a></p>"
);

undum.game.situations['landoffoops3serious'] = new undum.SimpleSituation(
	"<p>Um, okay, so this is a bit embarrassing, but I seem to have left out the most tiny chunk of this tale.  Page-balls!  It's getting worse.  All right, but I'm sure I can make up for it by just inserting it right here. How about you and I pretend that this had always been there -- except maybe much earlier in the story, okay?  Deal?</p>\
	<ul class='options'>\
		<li><a href='landoffoops3goodserious'>Deal</a></li>\
		<li><a href='landoffoops3goodserious'>Okay, deal.</a></li>\
		</ul>"
);


undum.game.situations['landoffoops3goodserious'] = new undum.SimpleSituation(
	"<p>Great. Glad we are on <a href='landdowncryserious'>the same page.</a></p>"
);

// DEal or no deal Question

undum.game.situations['landdowncryserious'] = new undum.SimpleSituation(
	"<p>It was evening at Mrs. Wobbles house, as Lin was staring as was her way at the Land Down Under through the glass on the landing of the first step. What a perfect world, she thought. This was before the lava episode of the mysterious floor and well before the events to come in this tale.  Lin could distinctly hear the sound of a boy's muffled weeping, rolling down from upstairs, a quivering, shaking sound <a href='landdowncry1serious'>from deep inside.</a></p>"
);

undum.game.situations['landdowncry1serious'] = new undum.SimpleSituation(
	"<p>As she followed the sound, she found herself standing silently outside one of the boys' rooms. The door was closed, and she approached noislessly.  Listening at the door, she heard the two new kids, the siblings, Wanda and Pete.  Pete was sobbing.</p>\
	<p>'Pete, Pete, trust me, it'll be all right. It always is. We'll just do it the way we always do.'</p>\
	<p>Between sobs, Pete managed to mutter, 'They're gonna make fun of my drooling.  You know they are. They're already staring.  And what is <a href='landdowncry2serious'>this place anyway?'</a></p>"
);

undum.game.situations['landdowncry2serious'] = new undum.SimpleSituation(
	"<p>But Wanda was insistent. 'Hush. Once they get a load of what I can dish out, no one is gonna say a word.' It sounded more to Lin like Wanda was saying this more to practice her mean voice than to comfort her brother.</p>\
	<p>'But then,' said Peter between sobs, 'No one will like us.'</p>\
	<p>'What do you mean us? Me. No one will like me,' said Wanda. 'And that's okay. I can take it. I can take the hit for both of us.'</p>\
	<p>And gradually Pete <a href='landdowncry3serious'>stopped crying.</a></p>"
);

undum.game.situations['landdowncry3serious'] = new undum.SimpleSituation(
	"<p>That was when Lin did something, well, accidental. She sort of let her guard down a bit, leaning onto the door with a bit too much weight and pushing suddenly open.</p>\
	<p>Pete and Wanda looked at her with horror.  Wanda took a half second to restore her bully face before saying in the most foul voice she could muster, 'Hey, why're you spying on us, slanty mouth? Can't you give some new kids some privacy around here even <a href='landdowncry4serious'>for a minute?'</a></p>"
);

undum.game.situations['landdowncry4serious'] = new undum.SimpleSituation(
	"<p>And Lin, so upset by her own mistake, so flustered, so bothered by Wanda's insults, left in silence.  But from then on, whenever Wanda was insulting her, Lin knew -- she absolutely knew that this was not the act of meaningless meanness, but the act of a loving sister, protecting her brother.</p>\
	<p>It was as if she heard every insult, translated, not into something kind, but into an act of kindness.  An arrow that hit like a daisy, not that it wasn't <a href='landdowncry5serious'>still a bit annoying.</a></p>"
);

undum.game.situations['landdowncry5serious'] = new undum.SimpleSituation(
	"<p>Oh, dear, that scene was a little bit important to this plot.  Um, I really need to get this whole condition of mine looked into.  Who knows what other parts of the story I'm leaving out.  I may be becoming a -- perish the thought -- unreliable -- no, I can't even permit the words to appear on my pages.</p>\
	<p>Trust me. I will do my best. **cough, cough**. Let's get back to <a href='landdownbattlefrown1'>where we were...</a></p>"
);
// Butterflies



undum.game.situations['landdownbattlefrown1'] = new undum.SimpleSituation(
	"<p>Paper butterflies took on waterjets in a battle the likes of which the tracked kingdom had never imagined.  For a while it seemed that the water jets would reign supreme.  To be soggy, was to be lost -- or at least out of the fight.  How could paper butterflies have any sway verses water cannons? </p>\
	<p>Only, there's a funny thing.  The more paper you blast with a water cannnon, the more pasty muck surrounds you.  Basically, the cannons were making paper mache plugs <a href='landdownbattlefrown2'>with each blast.</a></p>"

);


undum.game.situations['landdownbattlefrown2'] = new undum.SimpleSituation(
	"<p>What should Lin do?</p>\
	<ul class='options'>\
		<li><a href='landdownbattlefrown3'>Stay and watch the outcome of this war?</a></li>\
		<li><a href='landdownexit'>Leave this battle behind to return to Mrs. Wobbles now?</a></li>\
	</ul>"
);

undum.game.situations['landdownbattlefrown3'] = new undum.SimpleSituation(
"",
	{
		enter: function (character, system, from) {
			if (character.sandbox.landmettimmy == true){
		system.write("<p>In the chaos of the skies, it was hard to make out anything clearly, so it took a few minutes before Lin recognized the massive blimp that had arrived, delivering wet blobs of justice upon the King's forces. And it took even longer before she recognized the pilot. Through the great windows of the derigible was the boy she had met as balloon animal. Captain Timmy was at the helm and the sight of him was something to behold.</p>\
		<p>Once the paper airplanes could freely take the skies, they added the confetti poems the resistance had been writing. Words showered down everywhere, and the effect was like being swamped in <a href='landdownbattleend'>a tide of poetry bars.</a></p>");
			}
			else {
				system.write("<p>Once the paper airplanes could freely take the skies, they added the confetti poems the resistance had been writing. Words showered down everywhere, and the effect was like being swamped in <a href='landdownbattleend'>a tide of poetry bars.</a></p>");
			}
		}
	}	
);



// Lighthearted Battle

undum.game.situations['landdownbattlesmile'] = new undum.SimpleSituation(
	"<p>Ah, a lighthearted battle, if such a thing exists. Surely, the scenes of combat will seem fanciful.  But don't be deceived!  The battle between the flower and the wind is no less perilous merely because the combatants may seem so harmless <a href='landdownbattlesmiletrans'>to you and me.</a></p>"

);

// transition	

undum.game.situations['landdownbattlesmiletrans'] = new undum.SimpleSituation(
	"<p>But despite it being a fanciful battle, the noise of a battle churning into acting was deafening. And confusing.  Everywhere people were running and shouting.  And confusion, as you probably know, can make people very upset, <a href='landoffwandasmile'>angry even.</a></p>"
);



/*



// More of a transition

// Lighthearted Tangent
undum.game.situations['landoffwandasmile'] = new undum.SimpleSituation(
	"<p>Straining to overcome noise of war, Wanda was screaming at Lin, telling her to DO something.  Anything. Lin couldn't quiet her mind enough to figure out what she could do.  She couldn't believe Wanda was acting so mean even during a moment like this, after all they'd been through.</p>\
	<p>Finally, Lin could <a href='landoffwanda1smile'>take it no more.</a></p>"
);

/*Possibly add choices.
	Why do you have to be so mean?
	What is wrong with you?
	*/

undum.game.situations['landoffwanda1smile'] = new undum.SimpleSituation(
	"<p>'Why do you have to be such a bully?' Lin said, turning to face her. 'You've been nothing but mean to me in Mrs. Wobbles' house.'</p>\
	<p>'I--' but for once, Wanda was speechless -- stunned, actually, at Lin being so, so -- bold.</p>\
	<p>'What did I ever do to you? Was I mean?' asked Lin. 'No. I just tried to make you feel welcome from the start, but right away you had to start making fun of me.' </p>\
	<p>Again Wanda was <a href='landoffwanda2smile'>completely silent.</a></p>"
);

undum.game.situations['landoffwanda2smile'] = new undum.SimpleSituation(
	"<p>'I mean, I know this isn't the time for it, but -- if we're going to try to make it out of here, I need to know you're going to help me and not hurt me.'</p>\
	<p>And there in the corner of Wanda's eyes, were the beginnings of tears, which she quickly wiped away at risk of losing her paper face to watery streaks.  She began speaking softly.</p>\
	<p>'But don't you remember,' said Wanda, 'that first night when you walked into the room when I was consoling Pete?'</p>\
	<p>Lin scanned her memory.  She could remember <a href='landoffwanda3smile'>no such conversation.</a></p>"
);

undum.game.situations['landoffwanda3smile'] = new undum.SimpleSituation(
	"<p>'Pete was crying.  You came in, and I explained it all.'</p>\
	<p>Lin just shook her head. 'No,' and then she added.</p>\
	<p>'Really,' asked Wanda?  'How could you forget such an important...' and now she was searching for a word, <a href='landoffwhasmile'>'such an important...'</a></p>"
);

undum.game.situations['landoffwhasmile'] = new undum.SimpleSituation(
	"<p>'Scene?' added Lin, completing her sentence. Now, that was an unusual word to use. 'Wait,' And now Lin started looking around, scanning from left to right, up and down. 'I feel like something is missing from this... story?' Now, that is odd.  Wanda had no idea what she was talking about, and to be honest, speaking for my part as the narrator, I do not appreciate the insinuation, although I believe she is speaking figuratively, metaphorically.</p>\
	<p>But Lin continued, 'I mean, the story of our lives. It's like there's <a href='landoffoopssmile'>a section missing.'</a></p>"
);

undum.game.situations['landoffoopssmile'] = new undum.SimpleSituation(
	"<p>All right, all right, hold the tale.  As the person, the being, singularly responsible for delivering story elements, I am a bit concerned that Lin's most recent statement suggests that I, the book, have somehow dropped the storytelling ball in some way.  And I want to assure you --</p>\
	<p>'Wait,' Wanda interrupted my narration, 'How could you not remember?' asked Wanda.  'That wasn't that long ago.'<p>\
	<p>Lin then proceeded to speak, as if to me, me, the book, 'It's like someone did not include that part of the story when they <a href='landoffoops1smile'>were telling it.'</a></p>"
);

undum.game.situations['landoffoops1smile'] = new undum.SimpleSituation(
	"<p><em>What is this? <em>The Neverending Story</em>? I'm getting tired of <a href='landoffoops2smile'>this meta-ness.</em></a></p>"
);

undum.game.situations['landoffoops2smile'] = new undum.SimpleSituation(
	"<p>But now that I think about it, there <em>was</em> this passage I vaguely recall -- oh, dear.</p>\
	<p><a href='landoffoops3smile'>Hmmmm.</a></p>"
);

undum.game.situations['landoffoops3smile'] = new undum.SimpleSituation(
	"<p>Um, okay, so this is a bit embarrassing, but I seem to have left out the most tiny chunk of this tale.  Page-balls!  I thought I was recovering, but it's getting worse.  All right, but I'm sure I can make up for it by just inserting it right here. How about you and I pretend that this had always been there -- except maybe much earlier in the story, okay?  Deal?</p>\
	<ul class='options'>\
		<li><a href='landoffoops3goodsmile'>Deal</a></li>\
		<li><a href='landoffoops3goodsmile'>Okay, deal.</a></li>\
		</ul>"
);


undum.game.situations['landoffoops3goodsmile'] = new undum.SimpleSituation(
	"<p>Great. Glad we are on <a href='landdowncrysmile'>the same page.</a></p>"
);

// DEal or no deal Question

undum.game.situations['landdowncrysmile'] = new undum.SimpleSituation(
	"<p>It was evening at Mrs. Wobbles house, as Lin was staring as was her way at the Land Down Under through the glass on the landing of the first step. What a perfect world, she thought. This was before the lava episode of the mysterious floor and well before the events to come in this tale.  Lin could distinctly hear the sound of a boy's muffled weeping, rolling down from upstairs, a quivering, shaking sound <a href='landdowncry1'>from deep inside.</a></p>"
);

undum.game.situations['landdowncry1smile'] = new undum.SimpleSituation(
	"<p>As she followed the sound, she found herself standing silently outside one of the boys' rooms. The door was closed, and she approached noislessly.  Listening at the door, she heard the two new kids, the siblings, Wanda and Pete.  Pete was sobbing.</p>\
	<p>'Pete, Pete, trust me, it'll be all right. It always is. We'll just do it the way we always do.'</p>\
	<p>Between sobs, Pete managed to mutter, 'They're gonna make fun of my drooling.  You know they are. They're already staring.  And what is <a href='landdowncry2smile'>this place anyway?'</a></p>"
);

undum.game.situations['landdowncry2smile'] = new undum.SimpleSituation(
	"<p>But Wanda was insistent. 'Hush. Once they get a load of what I can dish out, no one is gonna say a word.' It sounded more to Lin like Wanda was saying this more to practice her mean voice than to comfort her brother.</p>\
	<p>'But then,' said Peter between sobs, 'No one will like us.'</p>\
	<p>'What do you mean us? Me. No one will like me,' said Wanda. 'And that's okay. I can take it. I can take the hit for both of us.'</p>\
	<p>And gradually Pete <a href='landdowncry3smile'>stopped crying.</a></p>"
);

undum.game.situations['landdowncry3smile'] = new undum.SimpleSituation(
	"<p>That was when Lin did something, well, accidental. She sort of let her guard down a bit, leaning onto the door with a bit too much weight and pushing suddenly open.</p>\
	<p>Pete and Wanda looked at her with horror.  Wanda took a half second to restore her bully face before saying in the most foul voice she could muster, 'Hey, why're you spying on us, slanty mouth? Can't you give some new kids some privacy around here even <a href='landdowncry4smile'>for a minute?'</a></p>"
);

undum.game.situations['landdowncry4smile'] = new undum.SimpleSituation(
	"<p>And Lin, so upset by her own mistake, so flustered, so bothered by Wanda's insults, left in silence.  But from then on, whenever Wanda was insulting her, Lin knew -- she absolutely knew that this was not the act of meaningless meanness, but the act of a loving sister, protecting her brother.</p>\
	<p>It was as if she heard every insult, translated, not into something kind, but into an act of kindness.  An arrow that hit like a daisy, not that it wasn't <a href='landdowncry5'>still a bit annoying.</a></p>"
);

undum.game.situations['landdowncry5smile'] = new undum.SimpleSituation(
	"<p>Oh, dear, that scene was a little bit important to this plot.  Um, I really need to get this whole condition of mine looked into.  Who knows what other parts of the story I'm leaving out.  I may be becoming a -- perish the thought -- unreliable -- no, I can't even permit the words to appear on my pages.</p>\
	<p>Trust me. I will do my best. **cough, cough**. Let's get back to <a href='landdownbattlesmile1'>where we were...</a></p>"
);




// END light hearted tangent	


undum.game.situations['landdownbattlesmile1'] = new undum.SimpleSituation(
	"<p>Do you wish to</p>\
	<ul>\
		<li><a href='landdownbattlesmile3'>to stay and watch the outcome of this war?</a></li>\
		<li><a href='landdownexit'>to leave this battle behind to return to Mr. Wobbles now?</a></li>\
	</ul>"
);

undum.game.situations['landdownbattlesmile3'] = new undum.SimpleSituation(
	"<p>It was Ant E Mice (aka Tickle bugs) vs. Bubblamos, creatures with the power to engulf anyone they touched in a bubble.  For a while it seemed that the Bubblamoses (Bubblami) would prove supreme, one after another engulfing the Ant E Mice.  But when the Ant E Mice discovered that their tickling could be used to pop the the Bubblamoses, the King's forces had no recourse and <a href='landdownbattleend'>soon were routed.</a></p>"

);


// The Ending
undum.game.situations['landdownbattleend'] = new undum.SimpleSituation(
	"<p>The King was stunned to see the devastation.  Everywhere he looked, the water was destroying the city, turning the great crisp edifices of paper into globs of soggy paper pulp.  As he prepared to stop the war, a paper airplane crashed straight into him.  At first it seemed as though it had not even affected him, but then, the grimace dropped from his snakelike face and his mighty serpentine body collapsed, <a href='landdownbattleend2'>crushing lines of track as it hit the ground.</a></p>"
);

undum.game.situations['landdownbattleend2'] = new undum.SimpleSituation(
	"<p>It was clear. He was out. There, beside the anti-papercraft guns, soggy with great water splotches, stretched the great and winding body of the King.</p>\
	<p>The Queen gasped and was at his side in an instant, holding him, even though touching his body <a href='landdownbattleend3'>made her soggy.</a></p>"
);


undum.game.situations['landdownbattleend3'] = new undum.SimpleSituation(
	"<p>'It was supposed to be perfection,' he mumbled. 'Your arms.' and yes, her arms were moistening and then sagging about to tear.</p>\
	<p>'I could <a href='landdownbattleend4'>make new arms.'</a></p>"
);

undum.game.situations['landdownbattleend4'] = new undum.SimpleSituation(
	"<p>And her tears rolled down her face and landed on his scales, which was when he changed utterly. As steam arose from his body, drying the paper around him as it rose, including the tears on the cheeks of the Queen, the King transformed into a something quite unlike a snake <a href='landdownbattleend5'>(at least in most cases), a man.</a></p>"
);

undum.game.situations['landdownbattleend5'] = new undum.SimpleSituation(
	"<p>This was how she had known him in the days before the underwater kingdom with which he had sought to control <a href='landdownexit'>all the paper.</a></p>"
);


// Exiting

undum.game.situations['landdownexit'] = new undum.SimpleSituation(
	"",
	{
		enter: function (character, system, from) {
			if (character.sandbox.metsafe== true) {
				if (character.sandbox.gotpete == true) {
					system.write("<p>Safe said this was the best moment for them to leave. So, grabbing Pete, Wanda and Lin left the Land Down Under to return to <a href='landdownendpete'>Mrs. Wobbles' home.</a></p>");
				}
				else {
					system.write("<p>Safe said this was the best moment for them. So, Wanda and Lin left the land down under without Pete to return to <a href='landdownpeteless'>Mrs. Wobbles' home.</a></p>");
				}
			}
			   else {
			if (character.sandbox.gotpete == true) {
				system.write("<p>Anna said this was the best moment for them to leave. So, grabbing Pete, Wanda and Lin left the Land Down Under to return to <a href='landdownendpete'>Mrs. Wobbles' home.</a></p>");
			}
			else {
				system.write("<p>Anna said this was the best moment for them. So, Wanda and Lin left the land down under without Pete to return to <a href='landdownpeteless'>Mrs. Wobbles' home.</a></p>");
			}
		  }
		}
	}
);



// Ending... on the stairs
//1) Peter is with them...

undum.game.situations['landdownendpete'] = new undum.SimpleSituation(
	"<p>I can't say that Lin, Peter, and Wanda became best friends because friendship doesn't work quite like that.  We like different people like, well, we like different books.  But I can say that once month, they meet at the steps and have a little viewing party.  Lin brings a bag of chips, and Wanda puts little braids in her hair. Pete even wears his shlocks, though really he wares them all the time anyway.</p>\
		<p>And they look into that glass panel to see what The Land Down <a href='landdownendpete1'>Under looks like.</a></p>"
);



undum.game.situations['landdownendpete1'] = new undum.SimpleSituation(
	"<p>Ah, the once perfect sight. As you might imagine, it was never the same -- or rather, it <em>is</em> never the same, for ever since the great civil war between the King and Queen, the Land Down Under ceased being that predictable, reliable little clockwork and became a city of constant change, always reimagining itself, tearing down what it used to be, and rebuilding into what it dreams to be.</p>\
	<p>Kind of like people, or at least people who are ready to hop off the track.</p>\
	<p>Lin still wondered...what happened to those people who were <a href='landdownpete2'>bumped off the track?</a></p>"
);

undum.game.situations['landdownpete2'] = new undum.SimpleSituation(
	"<p>But as another book has put it.  That is another story and should <a href='landownfinalend'>be told another time.</a></p>"
);







//2) Peter is not with them.

undum.game.situations['landdownpeteless'] = new undum.SimpleSituation(
	"<p>After the adventure, they never saw Pete again.  Well, not in the house anyway.  He became a part of the Land Down Under.</p>\
	<p>And one day, when Lin and Wanda met on the stairs and gazed down at The Land Down Under, as they sometimes would, Lin thought she saw someone who looked a little like Pete.  The man looked more or less like all the other citizens, except she swore that he wore schlocks.</p>\
	<p>'Maybe we'll go in and get him someday,' <a href='landdownpeteless1'>thought Lin.</a></p>"
);



undum.game.situations['landdownpeteless1'] = new undum.SimpleSituation(
	"<p>But as another book has put it: That is another story and shall <a href='landownfinalend'>be told another time.</a></p>"
);



undum.game.situations['landownfinalend'] = new undum.SimpleSituation(
	"<h1>The End</h1>\
		<p>And so ends The Land Down Under</p>\
		<p>Heartfelt thanks to <a href='./playtest' class='once'>our playtesters!</a></p>\
			 <p>If you would like to hear about future tales from Mrs. Wobbles, <a href='https://docs.google.com/forms/d/e/1FAIpQLSeZ2ltYDBwflsAoYeDkEVeqarvCpOzjO6C6MHLmWTgzHevEKw/viewform?usp=sf_link'>sign up here.</a> Or perhaps you realize you missed out on an exciting adventure and would like to  <a href='javascript:location.reload(true)' class='raw'>read it again.</a></p>",
	{
		enter: function (character, system, from) {
			system.setQuality("distance", "5/5");
			system.animateQuality("complete", character.qualities.complete + 20);
			if (character.qualities.complete != 100) {
				system.setQuality("complete", "100");
			}
		},
		actions: {
			'playtest': function (character, system, action) {
				system.write("<p>Thank you to playtesters!   These include Stepahnie Bower, James Marino, and Brian Rushton. And thanks to John Murray for some 11th hour coding help!</p>");
			}
		}

	}
);


/*



[They get their underwater outfits on]
They go down underneath the suits
are spun around
Then are raised up into them and head back down into the water




[The king is the one who invented the track]
Then they got divorced.

[Underwater they see pirranha]

[Behind the king is a switch
When they flick it, they are freed from the track]
[Dotted lines appear for folds]
[Fold their bottoms into feet, get ability to move mouths]


 
A girl who learns to fight her own battles.  A boy who learns that his talent may be magic
A Hotel under the basement
To get to the King, you have to wear a special suit, pink top, green bottoms�dive suit

The Enchanted Land
Good Guy
Fairy:  Lives in a tree. 
Broadcoo: Mushroom Dude: Guard , mushroom head
 
Bad guy
Ant E Mouse: Trickster, likes tickling people (lives on land)
Bubblamos: Bites, has teeth, can have stars on their bellies. 

Plant:
 
Ruler
Snake with a mowhawk, a line, and either a dot or crown.  He is a Bassilisk
 
The suit. 
 
 
//Abcdefghijklmnopqrstuv now you know your abcs next time will you sing with me
Abcdefghijklmnopqrstuvwxyz now you


[ANt E Mouse] -- is it a mouse?
[Maybe put more creatures sooner]


[Possibly introduce those who have been creating origami -- Origami in Lin's room]
They cut off pieces of their arms for paper? To create bend?

[We see a meeting -- the cutups? The folders?]
	[Secret meeting]
	[Choice to attend or not?

[Queen is outside to greet them]

	
	
	*/


//------------------------	
/* The Id of the starting situation. */
undum.game.start = "start";


// --------------------
/* Here we define all the qualities that our characters could
 * possess. We don't have to be exhaustive, but if we miss one out then
 * that quality will never show up in the character bar in the UI. */
undum.game.qualities = {
	skill: new undum.NumericQuality(
		"Poetry Powers", { priority: "0001", group: 'stats' }
	),
	strength: new undum.NumericQuality(
		"Page Points", { priority: "0002", group: 'stats' }
	),
    courage: new undum.CourageAdjectivesQuality(
		"Courage", {priority:"0003", group:'stats', onDisplay:"&#10003;"}
		),





	inspiration: new undum.NonZeroIntegerQuality(
		"Inspiration", { priority: "0001", group: 'progress' }
	),
	distance: new undum.NumericQuality(
		"Progress", { priority: "0002", group: 'progress', onDisplay: "&#10003;" }
	),
	complete: new undum.NumericQuality(
		"% Complete", { priority: "0003", group: 'progress', onDisplay: "&#10003;" }
	),
	jetpack: new undum.NumericQuality(
		"Jetpacks", { priority: "0004", group: 'stats' }
	)
};

// --------------------
/* The qualities are displayed in groups in the character bar. This
 * determines the groups, their heading (which can be null for no
 * heading) and ordering. QualityDefinitions without a group appear at
 * the end. It is an error to have a quality definition belong to a
 * non-existent group. */
undum.game.qualityGroups = {
	stats: new undum.QualityGroup(null, { priority: "0001" }),
	progress: new undum.QualityGroup('Mission', { priority: "0002" })
};

// --------------------
/* This function gets run before the game begins. It is normally used
 * to configure the character at the start of play. */
undum.game.init = function (character, system) {
	character.qualities.skill = 10;
	character.qualities.strength = 50;
	character.qualities.luck = 0;
	character.qualities.complete = 0;
	character.qualities.distance = "0/5";
	character.qualities.jetpack = 2;
	character.qualities.inspiration = 0;
	character.sandbox.name = "Reader";
	// Pirate story variables
	character.sandbox.sword = 0;
	character.sandbox.question1 = false;
	character.sandbox.question2 = false;
	character.sandbox.bones = 0;
	character.sandbox.map = 0;
	character.sandbox.mapfound = 0;
	character.sandbox.lamp = 0;
	character.sandbox.pet = "parrot";
	character.sandbox.part = "eye patch";
	character.sandbox.pname = "Scratchy";
	character.sandbox.rowrowrow = false;
	character.sandbox.frere = false;
	character.sandbox.rhymecount = 0;
	character.sandbox.sail = 2;
	character.sandbox.chased = true;
	// spy variables
	character.sandbox.gadget = "He-MO Glasses";
	character.sandbox.gadgetnumber = 5;
	character.sandbox.gadgets = [];
	character.sandbox.gadgets[0] = true;
	character.sandbox.gadgets[1] = false;
	character.sandbox.gadgets[2] = false;
	character.sandbox.gadgets[3] = false;
	character.sandbox.gadgets[4] = false;
	character.sandbox.gadgets[5] = false;
	character.sandbox.flown = [];
	character.sandbox.flown[0] = false;
	character.sandbox.flown[1] = false;
	character.sandbox.flown[2] = false;
	character.sandbox.flown[3] = false;
	character.sandbox.flown[4] = false;
	character.sandbox.flown[5] = false;
	character.sandbox.gotlifebooks = true;
	character.sandbox.bedtricks = 0;
	character.sandbox.elevator = false;
	character.sandbox.spypov = "Ichel";
	character.sandbox.spypovpro = "she";
	character.sandbox.spypovobj = "her";
	character.sandbox.spypovpos = "her";
	character.sandbox.spypovsib = "her brother";
	character.sandbox.spypov2 = "Juan";
	character.sandbox.spypovpro2 = "he";
	character.sandbox.spypovobj2 = "him";
	character.sandbox.spypovpos2 = "his";
	character.sandbox.spypovsib2 = "his sister";
	character.sandbox.spypovnum = 0;
	// Land Down Under variables
	character.sandbox.gotpete = false;
	character.qualities.courage = 2;
	character.qualities.couragearray= [2];
	system.setCharacterText("<p>What if everyone was the same?</p>");
    character.sandbox.balloon = 'giraffe';
	character.sandbox.metsafe= false;
	character.sandbox.landmettimmy = true;

};
